/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nd4j.linalg.api.memory.DeviceAllocationsTracker;
import org.nd4j.linalg.api.memory.enums.AllocationKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationsTracker {
    private static final Logger log = LoggerFactory.getLogger(AllocationsTracker.class);
    private static final AllocationsTracker INSTANCE = new AllocationsTracker();
    private Map<Integer, DeviceAllocationsTracker> devices = new ConcurrentHashMap<Integer, DeviceAllocationsTracker>();

    protected AllocationsTracker() {
    }

    public static AllocationsTracker getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceAllocationsTracker trackerForDevice(Integer deviceId) {
        DeviceAllocationsTracker tracker = this.devices.get(deviceId);
        if (tracker == null) {
            AllocationsTracker allocationsTracker = this;
            synchronized (allocationsTracker) {
                tracker = this.devices.get(deviceId);
                if (tracker == null) {
                    tracker = new DeviceAllocationsTracker();
                    this.devices.put(deviceId, tracker);
                }
            }
        }
        return tracker;
    }

    public void markAllocated(AllocationKind kind, Integer deviceId, long bytes) {
        DeviceAllocationsTracker tracker = this.trackerForDevice(deviceId);
        tracker.updateState(kind, bytes);
    }

    public void markReleased(AllocationKind kind, Integer deviceId, long bytes) {
        DeviceAllocationsTracker tracker = this.trackerForDevice(deviceId);
        tracker.updateState(kind, -bytes);
    }

    public long bytesOnDevice(Integer deviceId) {
        return this.bytesOnDevice(AllocationKind.GENERAL, deviceId);
    }

    public long bytesOnDevice(AllocationKind kind, Integer deviceId) {
        DeviceAllocationsTracker tracker = this.trackerForDevice(deviceId);
        return tracker.getState(kind);
    }
}

