/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.memory.deallocation;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.api.memory.Deallocator;

public class DeallocatableReference
extends WeakReference<Deallocatable> {
    private String id;
    private Deallocator deallocator;

    public DeallocatableReference(Deallocatable referent, ReferenceQueue<? super Deallocatable> q) {
        super(referent, q);
        this.id = referent.getUniqueId();
        this.deallocator = referent.deallocator();
    }

    public String getId() {
        return this.id;
    }

    public Deallocator getDeallocator() {
        return this.deallocator;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeallocator(Deallocator deallocator) {
        this.deallocator = deallocator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeallocatableReference)) {
            return false;
        }
        DeallocatableReference other = (DeallocatableReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Deallocator this$deallocator = this.getDeallocator();
        Deallocator other$deallocator = other.getDeallocator();
        return !(this$deallocator == null ? other$deallocator != null : !this$deallocator.equals(other$deallocator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeallocatableReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Deallocator $deallocator = this.getDeallocator();
        result = result * 59 + ($deallocator == null ? 43 : $deallocator.hashCode());
        return result;
    }

    public String toString() {
        return "DeallocatableReference(id=" + this.getId() + ", deallocator=" + this.getDeallocator() + ")";
    }
}

