/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.util.SameDiffUtils;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseReduceOp
extends BaseOp
implements ReduceOp {
    private static final Logger log = LoggerFactory.getLogger(BaseReduceOp.class);
    protected boolean keepDims = false;
    protected boolean isComplex = false;
    protected boolean isEmptyReduce = false;
    protected SDVariable dimensionVariable;
    private String dimensionVariableName;

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, int[] dimensions, boolean keepDims) {
        super(sameDiff, (Object[])null);
        if (i_v != null) {
            if (dimensions == null || dimensions.length < 1) {
                dimensions = new int[]{Integer.MAX_VALUE};
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.dimensions = dimensions;
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, i_v, this);
        this.keepDims = keepDims;
        this.xVertexId = i_v.name();
        sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
        this.defineDimensions(dimensions);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions, boolean keepDims) {
        super(sameDiff, (Object[])null);
        if (i_v != null) {
            if (dimensions == null || dimensions.length < 1) {
                dimensions = new int[]{Integer.MAX_VALUE};
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.dimensions = dimensions;
        this.xVertexId = i_v.name();
        this.yVertexId = i_v2.name();
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, i_v, this);
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, i_v2, this);
        this.keepDims = keepDims;
        sameDiff.addArgsFor(new String[]{this.xVertexId, this.yVertexId}, (DifferentialFunction)this);
        this.defineDimensions(dimensions);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v) {
        this(sameDiff, i_v, false);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        this(sameDiff, i_v, dimensions, false);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        this(sameDiff, i_v, i_v2, dimensions, false);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, boolean keepDims) {
        super(sameDiff, (Object[])null);
        if (i_v != null) {
            if (this.dimensions == null || this.dimensions.length < 1) {
                this.dimensions = new int[]{Integer.MAX_VALUE};
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, i_v, this);
        this.keepDims = keepDims;
        this.xVertexId = i_v.name();
        sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
        this.defineDimensions(this.dimensions);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, SDVariable dimensions, boolean keepDims) {
        super(sameDiff, (Object[])null);
        this.dimensionVariable = dimensions;
        this.xVertexId = i_v.name();
        this.yVertexId = dimensions.name();
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, i_v, this);
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, dimensions, this);
        this.keepDims = keepDims;
        sameDiff.addArgsFor(new String[]{this.xVertexId, this.yVertexId}, (DifferentialFunction)this);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2) {
        this(sameDiff, i_v, i_v2, false);
    }

    public BaseReduceOp() {
    }

    public BaseReduceOp(INDArray x, INDArray y, INDArray z, boolean keepDims, int[] dimensions) {
        super(x, y, z);
        this.keepDims = keepDims;
        this.dimensions = dimensions;
        this.defineDimensions(dimensions);
    }

    public BaseReduceOp(INDArray x, int ... dimensions) {
        this(x, null, dimensions);
    }

    public BaseReduceOp(INDArray x, boolean keepDims, int ... dimensions) {
        this(x, null, dimensions);
        this.keepDims = keepDims;
    }

    public BaseReduceOp(INDArray x, INDArray y, int ... dimensions) {
        this(x, y, null, dimensions);
    }

    public BaseReduceOp(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        this(x, y, z, false, dimensions);
    }

    public BaseReduceOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, SDVariable dimensions) {
        this(sameDiff, i_v, dimensions, false);
    }

    @Override
    public INDArray noOp() {
        if (this.z != null && this.x != this.z) {
            return this.z().assign(this.x);
        }
        if (this.keepDims) {
            return this.x().dup(this.x().ordering());
        }
        long[] shape = this.x.shape();
        if (this.dimensions == null || Shape.isWholeArray(shape, this.dimensions)) {
            return this.x.reshape(new long[0]).dup();
        }
        long[] outShape = ArrayUtil.removeIndex((long[])shape, (int[])this.dimensions);
        return this.x.dup('c').reshape('c', outShape);
    }

    @Override
    public boolean isKeepDims() {
        return this.keepDims;
    }

    @Override
    public abstract List<LongShapeDescriptor> calculateOutputShape();

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (!attributesForNode.containsKey("axis") && !this.hasReductionIndices(nodeDef)) {
            this.dimensions = new int[]{Integer.MAX_VALUE};
        }
        if (attributesForNode.containsKey("keep_dims")) {
            boolean keepDims;
            this.keepDims = keepDims = attributesForNode.get("keep_dims").getB();
        }
        this.defineDimensions(this.dimensions);
    }

    protected boolean hasReductionIndices(NodeDef nodeDef) {
        for (int i = 0; i < nodeDef.getInputCount(); ++i) {
            if (!nodeDef.getInput(i).contains("reduction_indices")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public boolean isComplexAccumulation() {
        return this.isComplex;
    }

    @Override
    public void setDimensions(int ... dimensions) {
        this.dimensions = dimensions;
        this.defineDimensions(dimensions);
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("isEmptyReduce")) {
            Boolean isEmptyReduce = this.getBooleanFromProperty("isEmptyReduce", properties);
            this.isEmptyReduce = isEmptyReduce;
        }
        if (properties.containsKey("keepDims")) {
            Boolean keepDims = this.getBooleanFromProperty("keepDims", properties);
            this.keepDims = keepDims;
        }
        if (properties.containsKey("isComplex")) {
            Boolean isComplex = this.getBooleanFromProperty("isComplex", properties);
            this.isComplex = isComplex;
        }
        if (properties.containsKey("dimensionz")) {
            INDArray array;
            this.dimensionz = array = (INDArray)properties.get("dimensionz");
        }
        if (properties.containsKey("dimensionVariable") && properties.get("dimensionVariable") != null) {
            String varName;
            this.dimensionVariableName = varName = properties.get("dimensionVariable").toString();
        }
    }

    @Override
    public void configureWithSameDiff(SameDiff sameDiff) {
        if (this.dimensionVariableName != null) {
            this.dimensionVariable = sameDiff.getVariable(this.dimensionVariableName);
        }
    }

    public void setKeepDims(boolean keepDims) {
        this.keepDims = keepDims;
    }

    public void setComplex(boolean isComplex) {
        this.isComplex = isComplex;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public void setEmptyReduce(boolean isEmptyReduce) {
        this.isEmptyReduce = isEmptyReduce;
    }

    public boolean isEmptyReduce() {
        return this.isEmptyReduce;
    }

    public void setDimensionVariable(SDVariable dimensionVariable) {
        this.dimensionVariable = dimensionVariable;
    }

    public SDVariable getDimensionVariable() {
        return this.dimensionVariable;
    }
}

