/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.executioner;

import java.util.List;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.impl.reduce.longer.MatchCondition;
import org.nd4j.linalg.exception.ND4JOpProfilerException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.linalg.profiler.OpProfiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutionerUtil {
    private static final Logger log = LoggerFactory.getLogger(OpExecutionerUtil.class);

    private OpExecutionerUtil() {
    }

    public static void checkForNaN(INDArray z) {
        if (!OpProfiler.getInstance().getConfig().isCheckForNAN()) {
            return;
        }
        if (z.isEmpty() || !z.dataType().isFPType()) {
            return;
        }
        int match = 0;
        if (!z.isScalar()) {
            MatchCondition condition = new MatchCondition(z, Conditions.isNan(), new int[0]);
            match = Nd4j.getExecutioner().exec(condition).getInt(0);
        } else if (z.data().dataType() == DataType.DOUBLE) {
            if (Double.isNaN(z.getDouble(0L))) {
                match = 1;
            }
        } else if (Float.isNaN(z.getFloat(0L))) {
            match = 1;
        }
        if (match > 0) {
            throw new ND4JOpProfilerException("P.A.N.I.C.! Op.Z() contains " + match + " NaN value(s)");
        }
    }

    public static void checkForAny(INDArray z) {
        OpExecutionerUtil.checkForNaN(z);
        OpExecutionerUtil.checkForInf(z);
    }

    public static void checkForInf(INDArray z) {
        if (!OpProfiler.getInstance().getConfig().isCheckForINF()) {
            return;
        }
        if (z.isEmpty() || !z.dataType().isFPType()) {
            return;
        }
        int match = 0;
        if (!z.isScalar()) {
            MatchCondition condition = new MatchCondition(z, Conditions.isInfinite(), new int[0]);
            match = Nd4j.getExecutioner().exec(condition).getInt(0);
        } else if (z.data().dataType() == DataType.DOUBLE) {
            if (Double.isInfinite(z.getDouble(0L))) {
                match = 1;
            }
        } else if (Float.isInfinite(z.getFloat(0L))) {
            match = 1;
        }
        if (match > 0) {
            throw new ND4JOpProfilerException("P.A.N.I.C.! Op.Z() contains " + match + " Inf value(s)");
        }
    }

    public static void checkForNaN(Op op, OpContext oc) {
        INDArray z;
        if (!OpProfiler.getInstance().getConfig().isCheckForNAN()) {
            return;
        }
        INDArray iNDArray = z = oc != null ? oc.getOutputArray(0) : op.z();
        if (z != null && !(op instanceof MatchCondition)) {
            OpExecutionerUtil.checkForNaN(z);
        }
    }

    public static void checkForInf(Op op, OpContext oc) {
        INDArray z;
        if (!OpProfiler.getInstance().getConfig().isCheckForINF()) {
            return;
        }
        INDArray iNDArray = z = oc != null ? oc.getOutputArray(0) : op.z();
        if (z != null && !(op instanceof MatchCondition)) {
            OpExecutionerUtil.checkForInf(z);
        }
    }

    public static void checkForInf(CustomOp op, OpContext oc) {
        if (!OpProfiler.getInstance().getConfig().isCheckForINF()) {
            return;
        }
        List<INDArray> inArgs = oc != null ? oc.getInputArrays() : op.inputArguments();
        List<INDArray> outArgs = oc != null ? oc.getOutputArrays() : op.outputArguments();
        for (INDArray input : inArgs) {
            OpExecutionerUtil.checkForInf(input);
        }
        for (INDArray output : outArgs) {
            OpExecutionerUtil.checkForInf(output);
        }
    }

    public static void checkForNaN(CustomOp op, OpContext oc) {
        if (!OpProfiler.getInstance().getConfig().isCheckForNAN()) {
            return;
        }
        List<INDArray> inArgs = oc != null ? oc.getInputArrays() : op.inputArguments();
        List<INDArray> outArgs = oc != null ? oc.getOutputArrays() : op.outputArguments();
        for (INDArray input : inArgs) {
            OpExecutionerUtil.checkForNaN(input);
        }
        for (INDArray output : outArgs) {
            OpExecutionerUtil.checkForNaN(output);
        }
    }
}

