/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class MergeMaxIndex
extends DynamicCustomOp {
    private DataType dataType = DataType.INT32;

    public MergeMaxIndex(@NonNull SameDiff sameDiff, SDVariable ... inputs) {
        super("mergemaxindex", sameDiff, inputs);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (inputs == null) {
            throw new NullPointerException("inputs is marked non-null but is null");
        }
        this.addIArgument(this.dataType.toInt());
    }

    public MergeMaxIndex(INDArray ... inputs) {
        super("mergemaxindex", inputs, null);
        if (inputs == null) {
            throw new NullPointerException("inputs is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)MergeMaxIndex.areEqualShapes(inputs), (String)"All inputs have to be equal shapes");
        this.addIArgument(this.dataType.toInt());
    }

    public MergeMaxIndex(@NonNull SameDiff sd, @NonNull SDVariable[] x, @NonNull DataType dataType) {
        super("mergemaxindex", sd, x);
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        this.dataType = dataType;
        this.addIArgument(dataType.toInt());
    }

    public MergeMaxIndex(@NonNull INDArray[] x, @NonNull DataType dataType) {
        super(x, null);
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)MergeMaxIndex.areEqualShapes(x), (String)"All inputs have to be equal shapes");
        this.dataType = dataType;
        this.addIArgument(dataType.toInt());
    }

    protected static boolean areEqualShapes(INDArray ... inputs) {
        for (INDArray input : inputs) {
            if (inputs[0].equalShapes(input)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String opName() {
        return "mergemaxindex";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Collections.singletonList(this.dataType);
    }

    public MergeMaxIndex() {
    }
}

