/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.NDArrayUtil;

public class FeatureUtil {
    public static INDArray toOutcomeVector(long index, long numOutcomes) {
        if (index > Integer.MAX_VALUE || numOutcomes > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        int[] nums = new int[(int)numOutcomes];
        nums[(int)index] = 1;
        return NDArrayUtil.toNDArray(nums);
    }

    public static INDArray toOutcomeMatrix(int[] index, long numOutcomes) {
        INDArray ret = Nd4j.create(index.length, numOutcomes);
        for (int i = 0; i < ret.rows(); ++i) {
            int[] nums = new int[(int)numOutcomes];
            nums[index[i]] = 1;
            ret.putRow(i, NDArrayUtil.toNDArray(nums));
        }
        return ret;
    }

    public static void normalizeMatrix(INDArray toNormalize) {
        INDArray columnMeans = toNormalize.mean(0);
        toNormalize.subiRowVector(columnMeans);
        INDArray std = toNormalize.std(0);
        std.addi(Nd4j.scalar(1.0E-12));
        toNormalize.diviRowVector(std);
    }

    public static void scaleByMax(INDArray toScale) {
        INDArray scale = toScale.max(1);
        for (int i = 0; i < toScale.rows(); ++i) {
            double scaleBy = scale.getDouble((long)i);
            toScale.putRow(i, toScale.getRow(i).divi(scaleBy));
        }
    }

    public static void scaleMinMax(double min, double max, INDArray toScale) {
        INDArray min2 = toScale.min(0);
        INDArray max2 = toScale.max(0);
        INDArray std = toScale.subRowVector(min2).diviRowVector(max2.sub(min2));
        INDArray scaled = std.mul(max - min).addi(min);
        toScale.assign(scaled);
    }
}

