/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.util.Arrays;
import java.util.List;
import org.nd4j.common.base.PreconditionsFormat;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class NDArrayPreconditionsFormat
implements PreconditionsFormat {
    private static final List<String> TAGS = Arrays.asList("%ndRank", "%ndShape", "%ndStride", "%ndLength", "%ndSInfo", "%nd10");

    public List<String> formatTags() {
        return TAGS;
    }

    public String format(String tag, Object arg) {
        if (arg == null) {
            return "null";
        }
        INDArray arr = (INDArray)arg;
        switch (tag) {
            case "%ndRank": {
                return String.valueOf(arr.rank());
            }
            case "%ndShape": {
                return Arrays.toString(arr.shape());
            }
            case "%ndStride": {
                return Arrays.toString(arr.stride());
            }
            case "%ndLength": {
                return String.valueOf(arr.length());
            }
            case "%ndSInfo": {
                return arr.shapeInfoToString().replaceAll("\n", "");
            }
            case "%nd10": {
                if (arr.isScalar() || arr.isEmpty()) {
                    return arr.toString();
                }
                INDArray sub = arr.reshape(arr.length()).get(NDArrayIndex.interval(0L, Math.min(arr.length(), 10L)));
                return sub.toString();
            }
        }
        throw new IllegalStateException("Unknown format tag: " + tag);
    }
}

