/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.nd4j.common.primitives.Pair;

public class MultiDimensionalMap<K, T, V>
implements Serializable {
    private Map<Pair<K, T>, V> backedMap;

    public static <K, T, V> MultiDimensionalMap<K, T, V> newThreadSafeTreeBackedMap() {
        return new MultiDimensionalMap(new ConcurrentSkipListMap());
    }

    public static <K, T, V> MultiDimensionalMap<K, T, V> newThreadSafeHashBackedMap() {
        return new MultiDimensionalMap(new ConcurrentHashMap());
    }

    public static <K, T, V> MultiDimensionalMap<K, T, V> newHashBackedMap() {
        return new MultiDimensionalMap(new HashMap());
    }

    public static <K, T, V> MultiDimensionalMap<K, T, V> newTreeBackedMap() {
        return new MultiDimensionalMap(new TreeMap());
    }

    public MultiDimensionalMap(Map<Pair<K, T>, V> backedMap) {
        this.backedMap = backedMap;
    }

    protected MultiDimensionalMap() {
    }

    public int size() {
        return this.backedMap.size();
    }

    public boolean isEmpty() {
        return this.backedMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.backedMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.backedMap.containsValue(value);
    }

    public V get(Object key) {
        return this.backedMap.get(key);
    }

    public V put(Pair<K, T> key, V value) {
        return this.backedMap.put(key, value);
    }

    public V remove(Object key) {
        return this.backedMap.remove(key);
    }

    public void putAll(Map<? extends Pair<K, T>, ? extends V> m) {
        this.backedMap.putAll(m);
    }

    public void clear() {
        this.backedMap.clear();
    }

    public Set<Pair<K, T>> keySet() {
        return this.backedMap.keySet();
    }

    public Collection<V> values() {
        return this.backedMap.values();
    }

    public Set<Entry<K, T, V>> entrySet() {
        HashSet<Entry<K, T, V>> ret = new HashSet<Entry<K, T, V>>();
        for (Pair<K, T> pair : this.backedMap.keySet()) {
            ret.add(new Entry<K, T, V>(pair.getFirst(), pair.getSecond(), this.backedMap.get(pair)));
        }
        return ret;
    }

    public V get(K k, T t) {
        return this.get(new Pair<K, T>(k, t));
    }

    public void put(K k, T t, V v) {
        this.put(new Pair<K, T>(k, t), v);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiDimensionalMap)) {
            return false;
        }
        MultiDimensionalMap that = (MultiDimensionalMap)o;
        return !(this.backedMap == null ? that.backedMap != null : !this.backedMap.equals(that.backedMap));
    }

    public int hashCode() {
        return this.backedMap != null ? this.backedMap.hashCode() : 0;
    }

    public String toString() {
        return "MultiDimensionalMap{backedMap=" + this.backedMap + '}';
    }

    public boolean contains(K k, T t) {
        return this.containsKey(new Pair<K, T>(k, t));
    }

    public static class Entry<K, T, V>
    implements Map.Entry<Pair<K, T>, V> {
        private K firstKey;
        private T secondKey;
        private V value;

        public Entry(K firstKey, T secondKey, V value) {
            this.firstKey = firstKey;
            this.secondKey = secondKey;
            this.value = value;
        }

        public K getFirstKey() {
            return this.firstKey;
        }

        public void setFirstKey(K firstKey) {
            this.firstKey = firstKey;
        }

        public T getSecondKey() {
            return this.secondKey;
        }

        public void setSecondKey(T secondKey) {
            this.secondKey = secondKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public Pair<K, T> getKey() {
            return new Pair<K, T>(this.firstKey, this.secondKey);
        }
    }
}

