/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.AllocationsTracker;
import org.nd4j.linalg.api.memory.enums.AllocationKind;
import org.nd4j.linalg.cache.ArrayDescriptor;
import org.nd4j.linalg.cache.BasicConstantHandler;
import org.nd4j.linalg.factory.Nd4j;

public class ConstantBuffersCache
extends BasicConstantHandler {
    protected Map<ArrayDescriptor, DataBuffer> buffersCache = new ConcurrentHashMap<ArrayDescriptor, DataBuffer>();
    private AtomicInteger counter = new AtomicInteger(0);
    private AtomicLong bytes = new AtomicLong(0L);
    private static final int MAX_ENTRIES = 1000;

    public void purgeConstants() {
        this.buffersCache = new ConcurrentHashMap<ArrayDescriptor, DataBuffer>();
    }

    public DataBuffer getConstantBuffer(int[] array, DataType dataType) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array, dataType);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createTypedBufferDetached((int[])array, (DataType)dataType);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType((DataType)dataType));
                AllocationsTracker.getInstance().markAllocated(AllocationKind.CONSTANT, Integer.valueOf(0), (long)(array.length * Nd4j.sizeOfDataType((DataType)dataType)));
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public DataBuffer getConstantBuffer(boolean[] array, DataType dataType) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array, dataType);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createTypedBufferDetached((boolean[])array, (DataType)dataType);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType((DataType)dataType));
                AllocationsTracker.getInstance().markAllocated(AllocationKind.CONSTANT, Integer.valueOf(0), (long)(array.length * Nd4j.sizeOfDataType((DataType)dataType)));
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public DataBuffer getConstantBuffer(double[] array, DataType dataType) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array, dataType);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createTypedBufferDetached((double[])array, (DataType)dataType);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType((DataType)dataType));
                AllocationsTracker.getInstance().markAllocated(AllocationKind.CONSTANT, Integer.valueOf(0), (long)(array.length * Nd4j.sizeOfDataType((DataType)dataType)));
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public DataBuffer getConstantBuffer(float[] array, DataType dataType) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array, dataType);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createTypedBufferDetached((float[])array, (DataType)dataType);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType((DataType)dataType));
                AllocationsTracker.getInstance().markAllocated(AllocationKind.CONSTANT, Integer.valueOf(0), (long)(array.length * Nd4j.sizeOfDataType((DataType)dataType)));
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public DataBuffer getConstantBuffer(long[] array, DataType dataType) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array, dataType);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createTypedBufferDetached((long[])array, (DataType)dataType);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType((DataType)dataType));
                AllocationsTracker.getInstance().markAllocated(AllocationKind.CONSTANT, Integer.valueOf(0), (long)(array.length * Nd4j.sizeOfDataType((DataType)dataType)));
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public long getCachedBytes() {
        return this.bytes.get();
    }
}

