/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.request;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.connection.netty.impl.messaging.request.RequestMessage;
import org.neo4j.bolt.connection.values.Value;

public record RouteMessage(Map<String, Value> routingContext, Set<String> bookmarks, String databaseName, String impersonatedUser) implements RequestMessage
{
    public static final byte SIGNATURE = 102;
    private static final String NAME = "ROUTE";

    public RouteMessage(Map<String, Value> routingContext, Set<String> bookmarks, String databaseName, String impersonatedUser) {
        this.routingContext = Collections.unmodifiableMap(routingContext);
        this.bookmarks = bookmarks;
        this.databaseName = databaseName;
        this.impersonatedUser = impersonatedUser;
    }

    @Override
    public byte signature() {
        return 102;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String toString() {
        return String.format("%s %s %s %s %s", NAME, this.routingContext, this.bookmarks, this.databaseName, this.impersonatedUser);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteMessage that = (RouteMessage)o;
        return this.routingContext.equals(that.routingContext) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.impersonatedUser, that.impersonatedUser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.routingContext, this.databaseName, this.impersonatedUser);
    }
}

