/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.bolt.connection.netty.impl.spi.ResponseHandler;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.bolt.connection.values.Value;

public class CommitTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<String> commitFuture;

    public CommitTxResponseHandler(CompletableFuture<String> commitFuture) {
        this.commitFuture = Objects.requireNonNull(commitFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        Value bookmarkValue = metadata.get("bookmark");
        String bookmark = null;
        if (bookmarkValue != null && !bookmarkValue.isNull() && Type.STRING.equals((Object)bookmarkValue.type()) && (bookmark = bookmarkValue.asString()).isEmpty()) {
            bookmark = null;
        }
        this.commitFuture.complete(bookmark);
    }

    @Override
    public void onFailure(Throwable error) {
        this.commitFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction commit is not expected to receive records: " + Arrays.toString(fields));
    }
}

