/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.routed.impl.cluster;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ClusterComposition;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.RoutingContext;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.bolt.connection.exception.BoltDiscoveryException;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.exception.BoltProtocolException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.bolt.connection.exception.BoltUnsupportedFeatureException;
import org.neo4j.bolt.connection.exception.MinVersionAcquisitionException;
import org.neo4j.bolt.connection.routed.ClusterCompositionLookupResult;
import org.neo4j.bolt.connection.routed.Rediscovery;
import org.neo4j.bolt.connection.routed.RoutingTable;
import org.neo4j.bolt.connection.routed.impl.AuthTokenManagerExecutionException;
import org.neo4j.bolt.connection.routed.impl.cluster.ResolvedBoltServerAddress;
import org.neo4j.bolt.connection.routed.impl.util.FutureUtil;
import org.neo4j.bolt.connection.summary.RouteSummary;

public class RediscoveryImpl
implements Rediscovery {
    private static final String NO_ROUTERS_AVAILABLE = "Could not perform discovery for database '%s'. No routing server available.";
    private static final String RECOVERABLE_ROUTING_ERROR = "Failed to update routing table with server '%s'.";
    private static final String RECOVERABLE_DISCOVERY_ERROR_WITH_SERVER = "Received a recoverable discovery error with server '%s', will continue discovery with other routing servers if available. Complete failure is reported separately from this entry.";
    private static final String TRANSACTION_INVALID_BOOKMARK_CODE = "Neo.ClientError.Transaction.InvalidBookmark";
    private static final String TRANSACTION_INVALID_BOOKMARK_MIXTURE_CODE = "Neo.ClientError.Transaction.InvalidBookmarkMixture";
    private static final String STATEMENT_ARGUMENT_ERROR_CODE = "Neo.ClientError.Statement.ArgumentError";
    private static final String REQUEST_INVALID_CODE = "Neo.ClientError.Request.Invalid";
    private static final String STATEMENT_TYPE_ERROR_CODE = "Neo.ClientError.Statement.TypeError";
    private final BoltServerAddress initialRouter;
    private final System.Logger log;
    private final Function<BoltServerAddress, Set<BoltServerAddress>> resolver;
    private final DomainNameResolver domainNameResolver;
    private final RoutingContext routingContext;
    private final BoltAgent boltAgent;
    private final String userAgent;
    private final int connectTimeoutMillis;

    public RediscoveryImpl(BoltServerAddress initialRouter, Function<BoltServerAddress, Set<BoltServerAddress>> resolver, LoggingProvider logging, DomainNameResolver domainNameResolver, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis) {
        this.initialRouter = initialRouter;
        this.log = logging.getLog(this.getClass());
        this.resolver = resolver;
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
        this.routingContext = routingContext;
        this.boltAgent = boltAgent;
        this.userAgent = userAgent;
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @Override
    public CompletionStage<ClusterCompositionLookupResult> lookupClusterComposition(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion) {
        CompletableFuture<ClusterCompositionLookupResult> result = new CompletableFuture<ClusterCompositionLookupResult>();
        BoltServiceUnavailableException baseError = new BoltServiceUnavailableException(String.format(NO_ROUTERS_AVAILABLE, routingTable.database().description()));
        this.lookupClusterComposition(securityPlan, routingTable, connectionProviderGetter, result, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, (Throwable)baseError);
        return result;
    }

    private void lookupClusterComposition(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, CompletableFuture<ClusterCompositionLookupResult> result, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        this.lookup(securityPlan, routingTable, connectionProviderGetter, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError).whenComplete((compositionLookupResult, completionError) -> {
            Throwable error = FutureUtil.completionExceptionCause(completionError);
            if (error != null) {
                result.completeExceptionally(error);
            } else if (compositionLookupResult != null) {
                result.complete((ClusterCompositionLookupResult)compositionLookupResult);
            } else {
                result.completeExceptionally(baseError);
            }
        });
    }

    private CompletionStage<ClusterCompositionLookupResult> lookup(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        CompletionStage<ClusterCompositionLookupResult> compositionStage = routingTable.preferInitialRouter() ? this.lookupOnInitialRouterThenOnKnownRouters(securityPlan, routingTable, connectionProviderGetter, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError) : this.lookupOnKnownRoutersThenOnInitialRouter(securityPlan, routingTable, connectionProviderGetter, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError);
        return compositionStage;
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnKnownRoutersThenOnInitialRouter(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        HashSet<BoltServerAddress> seenServers = new HashSet<BoltServerAddress>();
        return this.lookupOnKnownRouters(securityPlan, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError).thenCompose(compositionLookupResult -> {
            if (compositionLookupResult != null) {
                return CompletableFuture.completedFuture(compositionLookupResult);
            }
            return this.lookupOnInitialRouter(securityPlan, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError);
        });
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnInitialRouterThenOnKnownRouters(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        Set<BoltServerAddress> seenServers = Collections.emptySet();
        return this.lookupOnInitialRouter(securityPlan, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError).thenCompose(compositionLookupResult -> {
            if (compositionLookupResult != null) {
                return CompletableFuture.completedFuture(compositionLookupResult);
            }
            return this.lookupOnKnownRouters(securityPlan, routingTable, connectionProviderGetter, new HashSet<BoltServerAddress>(), bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError);
        });
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnKnownRouters(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<BoltServerAddress> seenServers, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        CompletionStage<Object> result = CompletableFuture.completedFuture(null);
        for (BoltServerAddress address : routingTable.routers()) {
            result = result.thenCompose(composition -> {
                if (composition != null) {
                    return CompletableFuture.completedFuture(composition);
                }
                return this.lookupOnRouter(securityPlan, address, true, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError);
            });
        }
        return result.thenApply(composition -> composition != null ? new ClusterCompositionLookupResult((ClusterComposition)composition) : null);
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnInitialRouter(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<BoltServerAddress> seenServers, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        List<BoltServerAddress> resolvedRouters;
        try {
            resolvedRouters = this.resolve();
        }
        catch (Throwable error) {
            return CompletableFuture.failedFuture(error);
        }
        HashSet<BoltServerAddress> resolvedRouterSet = new HashSet<BoltServerAddress>(resolvedRouters);
        resolvedRouters.removeAll(seenServers);
        CompletionStage<Object> result = CompletableFuture.completedFuture(null);
        for (BoltServerAddress address : resolvedRouters) {
            result = result.thenCompose(composition -> {
                if (composition != null) {
                    return CompletableFuture.completedFuture(composition);
                }
                return this.lookupOnRouter(securityPlan, address, false, routingTable, connectionProviderGetter, null, bookmarks, impersonatedUser, authTokenStageSupplier, minVersion, baseError);
            });
        }
        return result.thenApply(composition -> composition != null ? new ClusterCompositionLookupResult((ClusterComposition)composition, (Set<BoltServerAddress>)resolvedRouterSet) : null);
    }

    private CompletionStage<ClusterComposition> lookupOnRouter(SecurityPlan securityPlan, BoltServerAddress routerAddress, boolean resolveAddress, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<BoltServerAddress> seenServers, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        CompletableFuture<BoltServerAddress> addressFuture = CompletableFuture.completedFuture(routerAddress);
        CompletableFuture<ClusterComposition> future = new CompletableFuture<ClusterComposition>();
        final CompletableFuture compositionFuture = new CompletableFuture();
        AtomicReference connectionRef = new AtomicReference();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)addressFuture.thenApply(address -> resolveAddress ? this.resolveByDomainNameOrThrowCompletionException((BoltServerAddress)address, routingTable) : address)).thenApply(address -> this.addAndReturn(seenServers, address))).thenCompose(address -> ((BoltConnectionProvider)connectionProviderGetter.apply((BoltServerAddress)address)).connect(address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, securityPlan, null, authTokenStageSupplier, AccessMode.READ, bookmarks, null, minVersion, null, ignored -> {}, Collections.emptyMap()))).thenApply(connection -> {
            connectionRef.set(connection);
            return connection;
        })).thenCompose(connection -> connection.route(routingTable.database(), impersonatedUser, bookmarks))).thenCompose(connection -> connection.flush(new ResponseHandler(){
            ClusterComposition clusterComposition;
            Throwable throwable;

            public void onError(Throwable throwable) {
                this.throwable = throwable;
            }

            public void onRouteSummary(RouteSummary summary) {
                this.clusterComposition = summary.clusterComposition();
            }

            public void onComplete() {
                if (this.throwable != null) {
                    compositionFuture.completeExceptionally(this.throwable);
                } else {
                    compositionFuture.complete(this.clusterComposition);
                }
            }
        }))).thenCompose(ignored -> compositionFuture)).thenApply(clusterComposition -> {
            if (clusterComposition.routers().isEmpty() || clusterComposition.readers().isEmpty()) {
                throw new CompletionException((Throwable)new BoltProtocolException("Failed to parse result received from server due to no router or reader found in response."));
            }
            return clusterComposition;
        })).whenComplete((clusterComposition, throwable) -> {
            BoltConnection connection = (BoltConnection)connectionRef.get();
            CompletionStage<Object> connectionCloseStage = connection != null ? connection.close() : CompletableFuture.completedStage(null);
            Throwable cause = FutureUtil.completionExceptionCause(throwable);
            if (cause != null) {
                connectionCloseStage.whenComplete((ignored1, ignored2) -> {
                    try {
                        ClusterComposition composition = this.handleRoutingProcedureError(FutureUtil.completionExceptionCause(throwable), routingTable, routerAddress, baseError);
                        future.complete(composition);
                    }
                    catch (Throwable abortError) {
                        future.completeExceptionally(abortError);
                    }
                });
            } else {
                connectionCloseStage.whenComplete((ignored1, ignored2) -> future.complete((ClusterComposition)clusterComposition));
            }
        });
        return future;
    }

    private ClusterComposition handleRoutingProcedureError(Throwable error, RoutingTable routingTable, BoltServerAddress routerAddress, Throwable baseError) {
        if (this.mustAbortDiscovery(error)) {
            throw new CompletionException(error);
        }
        BoltDiscoveryException discoveryError = new BoltDiscoveryException(String.format(RECOVERABLE_ROUTING_ERROR, routerAddress), error);
        FutureUtil.combineErrors(baseError, (Throwable)discoveryError);
        this.log.log(System.Logger.Level.WARNING, RECOVERABLE_DISCOVERY_ERROR_WITH_SERVER, routerAddress);
        this.log.log(System.Logger.Level.DEBUG, String.format(RECOVERABLE_DISCOVERY_ERROR_WITH_SERVER, routerAddress), (Throwable)discoveryError);
        routingTable.forget(routerAddress);
        return null;
    }

    private boolean mustAbortDiscovery(Throwable throwable) {
        boolean abort = false;
        if (throwable instanceof BoltFailureException) {
            BoltFailureException boltFailureException = (BoltFailureException)throwable;
            String code = boltFailureException.code();
            abort = switch (RediscoveryImpl.extractErrorClass(code)) {
                case "ClientError" -> {
                    if ("Security".equals(RediscoveryImpl.extractErrorSubClass(code))) {
                        if (!"Neo.ClientError.Security.AuthorizationExpired".equalsIgnoreCase(code)) {
                            yield true;
                        }
                        yield false;
                    }
                    if ("Neo.ClientError.Database.DatabaseNotFound".equalsIgnoreCase(code)) {
                        yield true;
                    }
                    switch (code) {
                        case "Neo.ClientError.Transaction.InvalidBookmark": 
                        case "Neo.ClientError.Transaction.InvalidBookmarkMixture": 
                        case "Neo.ClientError.Statement.ArgumentError": 
                        case "Neo.ClientError.Request.Invalid": 
                        case "Neo.ClientError.Statement.TypeError": {
                            yield true;
                        }
                    }
                    yield false;
                }
                default -> false;
            };
        } else if (throwable instanceof IllegalStateException && "Connection provider is closed.".equals(throwable.getMessage())) {
            abort = true;
        } else if (throwable instanceof BoltUnsupportedFeatureException) {
            abort = true;
        } else if (throwable instanceof MinVersionAcquisitionException) {
            abort = true;
        } else if (throwable instanceof SSLHandshakeException) {
            abort = true;
        } else if (throwable instanceof AuthTokenManagerExecutionException) {
            abort = true;
        }
        return abort;
    }

    private static String extractErrorClass(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 2) {
            return "";
        }
        return parts[1];
    }

    private static String extractErrorSubClass(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 3) {
            return "";
        }
        return parts[2];
    }

    @Override
    public List<BoltServerAddress> resolve() throws UnknownHostException {
        LinkedList<BoltServerAddress> resolvedAddresses = new LinkedList<BoltServerAddress>();
        UnknownHostException exception = null;
        for (BoltServerAddress serverAddress : this.resolver.apply(this.initialRouter)) {
            try {
                this.resolveAllByDomainName(serverAddress).unicastStream().forEach(resolvedAddresses::add);
            }
            catch (UnknownHostException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (resolvedAddresses.isEmpty() && exception != null) {
            throw exception;
        }
        return resolvedAddresses;
    }

    private <T> T addAndReturn(Collection<T> collection, T element) {
        if (collection != null) {
            collection.add(element);
        }
        return element;
    }

    private BoltServerAddress resolveByDomainNameOrThrowCompletionException(BoltServerAddress address, RoutingTable routingTable) {
        try {
            ResolvedBoltServerAddress resolvedAddress = this.resolveAllByDomainName(address);
            routingTable.replaceRouterIfPresent(address, resolvedAddress);
            return resolvedAddress.unicastStream().findFirst().orElseThrow(() -> new IllegalStateException("Unexpected condition, the ResolvedBoltServerAddress must always have at least one unicast address"));
        }
        catch (Throwable e) {
            throw new CompletionException(e);
        }
    }

    private ResolvedBoltServerAddress resolveAllByDomainName(BoltServerAddress address) throws UnknownHostException {
        return new ResolvedBoltServerAddress(address.host(), address.port(), this.domainNameResolver.resolve(address.host()));
    }
}

