/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.v1.BoltProtocolV1;
import org.neo4j.driver.internal.messaging.v2.BoltProtocolV2;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.spi.Connection;

public interface BoltProtocol {
    public MessageFormat createMessageFormat();

    public void initializeChannel(String var1, Map<String, Value> var2, ChannelPromise var3);

    public void prepareToCloseChannel(Channel var1);

    public CompletionStage<Void> beginTransaction(Connection var1, Bookmark var2, TransactionConfig var3);

    public CompletionStage<Bookmark> commitTransaction(Connection var1);

    public CompletionStage<Void> rollbackTransaction(Connection var1);

    public ResultCursorFactory runInAutoCommitTransaction(Connection var1, Query var2, BookmarkHolder var3, TransactionConfig var4, boolean var5, long var6);

    public ResultCursorFactory runInUnmanagedTransaction(Connection var1, Query var2, UnmanagedTransaction var3, boolean var4, long var5);

    public int version();

    public static BoltProtocol forChannel(Channel channel) {
        return BoltProtocol.forVersion(ChannelAttributes.protocolVersion(channel));
    }

    public static BoltProtocol forVersion(int version) {
        switch (version) {
            case 1: {
                return BoltProtocolV1.INSTANCE;
            }
            case 2: {
                return BoltProtocolV2.INSTANCE;
            }
            case 3: {
                return BoltProtocolV3.INSTANCE;
            }
            case 4: {
                return BoltProtocolV4.INSTANCE;
            }
        }
        throw new ClientException("Unknown protocol version: " + version);
    }
}

