/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.URI;
import java.util.Objects;
import org.neo4j.driver.net.ServerAddress;

public record InternalServerAddress(String host, int port) implements ServerAddress
{
    public static final int DEFAULT_PORT = 7687;

    public InternalServerAddress {
        Objects.requireNonNull(host, "host");
        InternalServerAddress.requireValidPort(port);
    }

    public InternalServerAddress(String address) {
        this(InternalServerAddress.uriFrom(address));
    }

    public InternalServerAddress(URI uri) {
        this(InternalServerAddress.hostFrom(uri), InternalServerAddress.portFrom(uri));
    }

    private static void requireValidPort(int port) {
        if (port >= 0 && port <= 65535) {
            return;
        }
        throw new IllegalArgumentException("Illegal port: " + port);
    }

    private static String hostFrom(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            throw InternalServerAddress.invalidAddressFormat(uri);
        }
        return host;
    }

    private static int portFrom(URI uri) {
        int port = uri.getPort();
        return port == -1 ? 7687 : port;
    }

    private static RuntimeException invalidAddressFormat(URI uri) {
        return InternalServerAddress.invalidAddressFormat(uri.toString());
    }

    private static RuntimeException invalidAddressFormat(String address) {
        return new IllegalArgumentException("Invalid address format `" + address + "`");
    }

    private static URI uriFrom(String address) {
        String hostPort;
        Object scheme;
        String[] schemeSplit = address.split("://");
        if (schemeSplit.length == 1) {
            scheme = "bolt://";
            hostPort = InternalServerAddress.hostPortFrom(schemeSplit[0]);
        } else if (schemeSplit.length == 2) {
            scheme = schemeSplit[0] + "://";
            hostPort = InternalServerAddress.hostPortFrom(schemeSplit[1]);
        } else {
            throw InternalServerAddress.invalidAddressFormat(address);
        }
        return URI.create((String)scheme + hostPort);
    }

    private static String hostPortFrom(String address) {
        boolean containsSingleColon;
        if (address.startsWith("[")) {
            return address;
        }
        boolean bl = containsSingleColon = address.indexOf(":") == address.lastIndexOf(":");
        if (containsSingleColon) {
            return address;
        }
        return "[" + address + "]";
    }

    @Override
    public String toString() {
        return String.format("%s:%d", this.host, this.port);
    }
}

