/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.exceptions.value.ValueException;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.value.BoltValue;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.ValueAdapter;

public class ListValue
extends ValueAdapter {
    private final Value[] values;

    public ListValue(Value ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Cannot construct ListValue from null");
        }
        this.values = values;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public List<Object> asObject() {
        return this.asList(Values.ofObject());
    }

    @Override
    public List<Object> asList() {
        return Extract.list(this.values, Values.ofObject());
    }

    @Override
    public <T> List<T> asList(Function<Value, T> mapFunction) {
        return Extract.list(this.values, mapFunction);
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.isAssignableFrom(List.class)) {
            return targetClass.cast(this.asList());
        }
        if (targetClass.isArray()) {
            TypeDescriptor.OfField componentType = targetClass.componentType();
            Object array = Array.newInstance(componentType, this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                Object value;
                try {
                    value = this.values[i].as(componentType);
                }
                catch (Throwable throwable) {
                    throw new ValueException("Failed to map LIST value to %s - an error occured while mapping the element at index %d".formatted(targetClass.getCanonicalName(), i), throwable);
                }
                Array.set(array, i, value);
            }
            return targetClass.cast(array);
        }
        throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
    }

    @Override
    public Object as(ParameterizedType type) {
        Class cls;
        java.lang.reflect.Type rawType = type.getRawType();
        if (rawType instanceof Class && (cls = (Class)rawType).isAssignableFrom(List.class)) {
            return this.asList((Value v) -> {
                InternalValue value = (InternalValue)v;
                java.lang.reflect.Type typeArgument = type.getActualTypeArguments()[0];
                return value.as(typeArgument);
            });
        }
        throw new Uncoercible(this.type().name(), type.toString());
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Value get(int index) {
        return index >= 0 && index < this.values.length ? this.values[index] : Values.NULL;
    }

    @Override
    public <T> Iterable<T> values(final Function<Value, T> mapFunction) {
        return () -> new Iterator<T>(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < ListValue.this.values.length;
            }

            @Override
            public T next() {
                return mapFunction.apply(ListValue.this.values[this.cursor++]);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.LIST();
    }

    @Override
    public String toString() {
        return Arrays.toString(this.values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValue otherValues = (ListValue)o;
        return Arrays.equals(this.values, otherValues.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public BoltValue asBoltValue() {
        return new BoltValue(this, Type.LIST);
    }
}

