/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class HelloV51ResponseHandler
implements ResponseHandler {
    private static final String CONNECTION_ID_METADATA_KEY = "connection_id";
    private final Channel channel;
    private final CompletableFuture<Void> helloFuture;

    public HelloV51ResponseHandler(Channel channel, CompletableFuture<Void> helloFuture) {
        this.channel = channel;
        this.helloFuture = helloFuture;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            String serverAgent = MetadataExtractor.extractServer(metadata).asString();
            ChannelAttributes.setServerAgent(this.channel, serverAgent);
            String connectionId = HelloV51ResponseHandler.extractConnectionId(metadata);
            ChannelAttributes.setConnectionId(this.channel, connectionId);
            this.helloFuture.complete(null);
        }
        catch (Throwable error) {
            this.onFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener(future -> this.helloFuture.completeExceptionally(error));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private static String extractConnectionId(Map<String, Value> metadata) {
        Value value = metadata.get(CONNECTION_ID_METADATA_KEY);
        if (value == null || value.isNull()) {
            throw new IllegalStateException("Unable to extract connection_id from a response to HELLO message. Received metadata: " + metadata);
        }
        return value.asString();
    }
}

