/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.messaging.Message;

public abstract class AbstractStreamingMessage
implements Message {
    private final Map<String, Value> metadata = new HashMap<String, Value>();
    public static final long STREAM_LIMIT_UNLIMITED = -1L;

    AbstractStreamingMessage(long n, long id) {
        this.metadata.put("n", Values.value(n));
        if (id != -1L) {
            this.metadata.put("qid", Values.value(id));
        }
    }

    public Map<String, Value> metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStreamingMessage that = (AbstractStreamingMessage)o;
        return Objects.equals(this.metadata, that.metadata);
    }

    protected abstract String name();

    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    public String toString() {
        return String.format("%s %s", this.name(), this.metadata);
    }
}

