/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactivestreams;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.reactive.AbstractReactiveTransaction;
import org.neo4j.driver.internal.reactivestreams.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactivestreams.InternalReactiveResult;
import org.neo4j.driver.reactivestreams.ReactiveResult;
import org.neo4j.driver.reactivestreams.ReactiveTransaction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class InternalReactiveTransaction
extends AbstractReactiveTransaction
implements ReactiveTransaction,
BaseReactiveQueryRunner {
    private final DriverObservationProvider observationProvider;

    protected InternalReactiveTransaction(UnmanagedTransaction tx, DriverObservationProvider observationProvider) {
        super(tx);
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public Publisher<ReactiveResult> run(Query query) {
        CompletionStage<Object> cursorStage;
        Observation runObservation = this.observationProvider.transactionRun(ReactiveTransaction.class, query.text(), query.parameters()).start();
        try {
            cursorStage = this.tx.runRx(query, runObservation);
        }
        catch (Throwable t) {
            cursorStage = CompletableFuture.failedFuture(t);
        }
        return ObservationUtil.observeStreamsWithoutStart(runObservation, Mono.fromCompletionStage(cursorStage).flatMap(cursor -> {
            Mono publisher;
            Throwable runError = cursor.getRunError();
            if (runError != null) {
                publisher = Mono.error((Throwable)runError);
                this.tx.markTerminated(runError);
            } else {
                publisher = Mono.just((Object)cursor);
            }
            return publisher;
        }).map(result -> new InternalReactiveResult((RxResultCursor)result, this.observationProvider)), false);
    }

    public Publisher<Void> terminate() {
        return Mono.fromCompletionStage(this.tx.terminateAsync());
    }

    @Override
    public <T> Publisher<T> commit() {
        Observation commitObservation = this.observationProvider.transactionCommit(ReactiveTransaction.class);
        return ObservationUtil.observeStreams(commitObservation, this.doCommit(commitObservation));
    }

    @Override
    public <T> Publisher<T> rollback() {
        Observation rollbackObservation = this.observationProvider.transactionRollback(ReactiveTransaction.class);
        return ObservationUtil.observeStreams(rollbackObservation, this.doRollback(rollbackObservation));
    }

    @Override
    public Publisher<Void> close() {
        Observation closeObservation = this.observationProvider.transactionClose(ReactiveTransaction.class);
        return ObservationUtil.observeStreams(closeObservation, this.doClose(closeObservation));
    }

    @Override
    public Publisher<Boolean> isOpen() {
        return this.doIsOpen();
    }
}

