/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.semantics;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.UsingJoinHint;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticErrorDef;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;

public final class SemanticError$
implements Serializable {
    public static final SemanticError$ MODULE$ = new SemanticError$();
    private static final String existsErrorMessage = "The EXISTS expression is not valid in driver settings.";
    private static final String countErrorMessage = "The COUNT expression is not valid in driver settings.";
    private static final String collectErrorMessage = "The COLLECT expression is not valid in driver settings.";
    private static final String genericErrorMessage = "This expression is not valid in driver settings.";
    private static final String validLastClauses = "a RETURN clause, a FINISH clause, an update clause, a unit subquery call, or a procedure call with no YIELD";

    public SemanticError apply(String msg, InputPosition position) {
        return new SemanticError(null, msg, position);
    }

    public Option<Tuple2<String, InputPosition>> unapply(SemanticErrorDef errorDef) {
        return new Some((Object)new Tuple2((Object)errorDef.msg(), (Object)errorDef.position()));
    }

    public SemanticError invalidOption(String schemaString, String invalidOptions, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidOptions, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), java.util.List.of("indexProvider", "indexConfig"), (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Failed to create " + schemaString + ": Invalid option provided, valid options are `indexProvider` and `indexConfig`.", position);
    }

    public SemanticError authForbidsClauseError(String provider, String unsupportedClause, java.util.List<String> expected, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)unsupportedClause, (String)("auth provider " + GqlParams.StringParam.input.process((Object)provider) + " attribute"), expected, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Auth provider `" + provider + "` does not allow `" + unsupportedClause + "` clause.", position);
    }

    public SemanticError unsupportedActionAccess(String actionName, java.util.List<String> expectedActions, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)actionName, (String)"property value access rules", expectedActions, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, actionName + " is not supported for property value access rules.", position);
    }

    public SemanticError yieldMissingColumn(String originalName, java.util.List<String> expectedColumns, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)originalName, (String)"column name", expectedColumns, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Trying to YIELD non-existing column: `" + originalName + "`", position);
    }

    public SemanticError invalidFunctionForIndex(String entityIndexDescription, String name, String validFunction, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)name, (String)"function name", java.util.List.of(validFunction), (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Failed to create " + entityIndexDescription + ": Function '" + name + "' is not allowed, valid function is '" + validFunction + "'.", position);
    }

    public SemanticError invalidUseOfGraphFunction(String graphFunction, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.line(), pos.column(), pos.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N75).atPosition(pos.line(), pos.column(), pos.offset()).withParam(GqlParams.StringParam.fun, graphFunction).build()).build();
        return new SemanticError(gql, "`" + graphFunction + "` is only allowed at the first position of a USE clause.", pos);
    }

    public String existsErrorMessage() {
        return existsErrorMessage;
    }

    public String countErrorMessage() {
        return countErrorMessage;
    }

    public String collectErrorMessage() {
        return collectErrorMessage;
    }

    public String genericErrorMessage() {
        return genericErrorMessage;
    }

    public SemanticError existsInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"EXISTS"), (String)"driver settings", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, this.existsErrorMessage(), position);
    }

    public SemanticError countInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"COUNT"), (String)"driver settings", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, this.countErrorMessage(), position);
    }

    public SemanticError collectInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"COLLECT"), (String)"driver settings", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, this.collectErrorMessage(), position);
    }

    public SemanticError genericDriverSettingsFail(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"EXISTS"), (String)"driver settings", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, this.genericErrorMessage(), position);
    }

    public SemanticError cannotUseJoinHint(UsingJoinHint hint, String prettifiedHint) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N76).withParam(GqlParams.ListParam.hintList, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)prettifiedHint, (List)Nil$.MODULE$)).asJava()).atPosition(hint.position().line(), hint.position().column(), hint.position().offset()).build();
        return new SemanticError(gql, "Cannot use join hint for single node pattern.", hint.position());
    }

    public SemanticError variableAlreadyDeclaredInOuterScope(String name, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N07((String)name, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Variable `" + name + "` already declared in outer scope", position);
    }

    public SemanticError variableShadowingOuterScope(String name, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N07((String)name, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "The variable `" + name + "` is shadowing a variable with the same name from the outer scope and needs to be renamed", position);
    }

    public SemanticError legacyDisjunction(String sanitizedLabelExpression, boolean containsIs, boolean isNode, InputPosition position) {
        String isOrColon = containsIs ? "IS " : ":";
        String msg = isNode ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Label expressions are not allowed to contain '|:'.\n         |If you want to express a disjunction of labels, please use `" + isOrColon + sanitizedLabelExpression + "` instead")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The semantics of using colon in the separation of alternative relationship types in conjunction with\n         |the use of variable binding, inlined property predicates, or variable length is no longer supported.\n         |Please separate the relationships types using `" + isOrColon + sanitizedLabelExpression + "` instead."));
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I20((String)"|:", (String)"|", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, msg, position);
    }

    public boolean legacyDisjunction$default$3() {
        return false;
    }

    public SemanticError invalidDisjunction(boolean isNode, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I20((String)(isNode ? "|:" : ":"), (String)"|", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, isNode ? "Label expressions are not allowed to contain '|:'." : "Relationship types in a relationship type expressions may not be combined using ':'", position);
    }

    public SemanticError subPathAssignmentNotSupported(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N42((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Sub-path assignment is currently not supported.", position);
    }

    public SemanticError unsupportedRequestOnSystemDatabase(String invalidInput, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N17).withParam(GqlParams.StringParam.input, invalidInput).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidInput(String wrongInput, String forField, List<String> expectedInput, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.line(), pos.column(), pos.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N04).atPosition(pos.line(), pos.column(), pos.offset()).withParam(GqlParams.StringParam.input, wrongInput).withParam(GqlParams.StringParam.context, forField).withParam(GqlParams.ListParam.inputList, java.util.List.of(expectedInput)).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidEntityType(String invalidInput, String variable, List<String> expectedValueList, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)invalidInput, (String)variable, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(expectedValueList).asJava(), (int)pos.line(), (int)pos.column(), (int)pos.offset());
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError typeMismatch(List<String> expectedValueList, String wrongType, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.line(), pos.column(), pos.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB1).atPosition(pos.line(), pos.column(), pos.offset()).withParam(GqlParams.ListParam.valueTypeList, CollectionConverters$.MODULE$.SeqHasAsJava(expectedValueList).asJava()).withParam(GqlParams.StringParam.input, wrongType).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidCoercion(String cannotCoerceFrom, String cannotCoerceTo, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.line(), pos.column(), pos.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N37).atPosition(pos.line(), pos.column(), pos.offset()).withParam(GqlParams.StringParam.value, cannotCoerceFrom).withParam(GqlParams.StringParam.valueType, cannotCoerceTo).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError specifiedNumberOutOfRange(String component, String valueType, Number lower, Number upper, String inputValue, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.line(), pos.column(), pos.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N31).atPosition(pos.line(), pos.column(), pos.offset()).withParam(GqlParams.StringParam.component, component).withParam(GqlParams.StringParam.valueType, valueType).withParam(GqlParams.NumberParam.lower, lower).withParam(GqlParams.NumberParam.upper, upper).withParam(GqlParams.StringParam.value, inputValue).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError propertyTypeUnsupportedInConstraint(String constraintTypeDescription, CypherType originalPropertyType) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N11).withParam(GqlParams.StringParam.constrDescrOrName, constraintTypeDescription + " constraint").withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N90).withParam(GqlParams.StringParam.item, originalPropertyType.description()).build()).build();
        return new SemanticError(gql, "Failed to create " + constraintTypeDescription + " constraint: Invalid property type `" + originalPropertyType.description() + "`.", originalPropertyType.position());
    }

    public SemanticError missingMandatoryAuthClause(String clause, String authProvider, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N97).withParam(GqlParams.StringParam.clause, clause).withParam(GqlParams.StringParam.auth, authProvider).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError duplicateClause(String clause, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N19).withParam(GqlParams.StringParam.syntax, clause).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError missingHintPredicate(String legacyMessage, String hint, String entity, String variable, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N76).withParam(GqlParams.ListParam.hintList, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)hint, (List)Nil$.MODULE$)).asJava()).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N77).withParam(GqlParams.StringParam.hint, hint).withParam(GqlParams.StringParam.entityType, entity).withParam(GqlParams.StringParam.variable, variable).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError functionRequiresWhereClause(String func, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N70).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.fun, func).build()).build();
        return new SemanticError(gql, func + "(...) requires a WHERE predicate", position);
    }

    public SemanticError aExpressionCannotContainUpdates(String expr, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N57((String)expr, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "A " + expr + " Expression cannot contain any updates", position);
    }

    public SemanticError anExpressionCannotContainUpdates(String expr, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N57((String)expr, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "An " + expr + " Expression cannot contain any updates", position);
    }

    public SemanticError singleReturnColumnRequired(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N22((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "A Collect Expression must end with a single return column.", position);
    }

    public SemanticError emptyListRangeOperator(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N20).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, "The start or end (or both) is required for a collection slice", position);
    }

    public SemanticError unboundVariablesInPatternExpression(String name, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N29).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.variable, name).build()).build();
        return new SemanticError(gql, "PatternExpressions are not allowed to introduce new variables: '" + name + "'.", position);
    }

    public SemanticError incompatibleReturnColumns(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N39((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "All sub queries in an UNION must have the same return column names", position);
    }

    public SemanticError invalidUseOfUnion(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I40).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, "Invalid combination of UNION and UNION ALL", position);
    }

    public SemanticError invalidUseOfCIT(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I25((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "CALL { ... } IN TRANSACTIONS after a write clause is not supported", position);
    }

    public SemanticError invalidUseOfReturn(String name, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I38).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, name + " can only be used at the end of the query.", position);
    }

    public SemanticError invalidUseOfReturnStar(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I37).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, "RETURN * is not allowed when there are no variables in scope", position);
    }

    public SemanticError invalidUseOfMatch(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I31).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, "MATCH cannot follow OPTIONAL MATCH (perhaps use a WITH clause between them)", position);
    }

    public SemanticError invalidQuantifier(scala.collection.immutable.Seq<String> variables, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I18).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.ListParam.variableList, CollectionConverters$.MODULE$.SeqHasAsJava(variables).asJava()).build()).build();
        String errorMsg = this.implicitGroupingExpressionInAggregationColumnErrorMessage(variables);
        return new SemanticError(gql, errorMsg, position);
    }

    public SemanticError invalidForeach(String clause, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I01).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.clause, clause).build()).build();
        return new SemanticError(gql, "Invalid use of " + clause + " inside FOREACH", position);
    }

    public SemanticError unaliasedReturnItem(String clause, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N21).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.clause, clause).build()).build();
        return new SemanticError(gql, "Expression in " + clause + " must be aliased (use AS)", position);
    }

    public String implicitGroupingExpressionInAggregationColumnErrorMessage(scala.collection.immutable.Seq<String> variables) {
        return "Aggregation column contains implicit grouping expressions. For example, in 'RETURN n.a, n.a + n.b + count(*)' the aggregation expression 'n.a + n.b + count(*)' includes the implicit grouping key 'n.b'. It may be possible to rewrite the query by extracting these grouping/aggregation expressions into a preceding WITH clause. Illegal expression(s): " + variables.mkString(", ");
    }

    public SemanticError accessingMultipleGraphsError(String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA5).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError numberTooLarge(String numberType, String value, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003((String)value, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, numberType + " is too large", position);
    }

    public SemanticError integerOperationCannotBeRepresented(String operation, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003((String)operation, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "result of " + operation + " cannot be represented as an integer", position);
    }

    public SemanticError notSupported(InputPosition pos) {
        String msg = "Not supported.";
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)this.getClass().getSimpleName(), (String)msg, (int)pos.line(), (int)pos.column(), (int)pos.offset());
        return new SemanticError(gql, msg, pos);
    }

    public SemanticError bothOrReplaceAndIfNotExists(String entity, String userAsString, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"OR REPLACE", (String)"IF NOT EXISTS", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Failed to create the specified " + entity + " '" + userAsString + "': cannot have both `OR REPLACE` and `IF NOT EXISTS`.", position);
    }

    public SemanticError badCommandWithOrReplace(String cmd, String cypherCmd, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"OR REPLACE", (String)cypherCmd, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Failed to " + cmd + ": `OR REPLACE` cannot be used together with this command.", position);
    }

    public SemanticError denyMergeUnsupported(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"DENY", (String)"MERGE", (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "`DENY MERGE` is not supported. Use `DENY SET PROPERTY` and `DENY CREATE` instead.", position);
    }

    public SemanticError grantDenyRevokeUnsupported(String cmd, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"GRANT, DENY and REVOKE", (String)cmd, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "`GRANT`, `DENY` and `REVOKE` are not supported for `" + cmd + "`", position);
    }

    public SemanticError unableToRouteUseClauseError(String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N04).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.clause, "`USE` clause").build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError invalidNumberOfProcedureOrFunctionArguments(int expectedNumberOfArgs, int obtainedNumberOfArgs, String procedureFunction, String signature, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I13).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.NumberParam.count1, (Number)Predef$.MODULE$.int2Integer(expectedNumberOfArgs)).withParam(GqlParams.NumberParam.count2, (Number)Predef$.MODULE$.int2Integer(obtainedNumberOfArgs)).withParam(GqlParams.StringParam.procFun, procedureFunction).withParam(GqlParams.StringParam.sig, signature).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError invalidYieldStar(String commandName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N94).build();
        return new SemanticError(gql, "When combining `" + commandName + "` with other show and/or terminate commands, `YIELD *` isn't permitted.", position);
    }

    public SemanticError missingYield(String commandName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N93).build();
        return new SemanticError(gql, "When combining `" + commandName + "` with other show and/or terminate commands, `YIELD` is mandatory.", position);
    }

    public SemanticError missingReturn(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N92).build();
        return new SemanticError(gql, "When combining show and/or terminate commands, `RETURN` isn't optional.", position);
    }

    public SemanticError queryMustConcludeWithClause(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N71((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Query must conclude with " + this.validLastClauses() + ".", position);
    }

    public SemanticError queryCannotConcludeWithCall(String callName, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N71((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Query cannot conclude with " + callName + " together with YIELD", position);
    }

    public SemanticError queryCannotConcludeWithClause(String clause, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N71((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Query cannot conclude with " + clause + " (must be " + this.validLastClauses() + ").", position);
    }

    private String validLastClauses() {
        return validLastClauses;
    }

    public SemanticError withIsRequiredBetween(String clause1, String clause2, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N24((String)clause1, (String)clause2, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "WITH is required between " + clause1 + " and " + clause2, position);
    }

    public SemanticError invalidType(String value, List<String> correctTypes, String actualType, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22G03).atPosition(pos.line(), pos.column(), pos.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N01).atPosition(pos.line(), pos.column(), pos.offset()).withParam(GqlParams.StringParam.value, value).withParam(GqlParams.ListParam.valueTypeList, CollectionConverters$.MODULE$.SeqHasAsJava(correctTypes).asJava()).withParam(GqlParams.StringParam.valueType, actualType).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidPlacementOfUseClause(InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.line(), pos.column(), pos.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N73).atPosition(pos.line(), pos.column(), pos.offset()).build()).build();
        return new SemanticError(gql, "USE clause must be the first clause in a (sub-)query.", pos);
    }

    public SemanticError invalidSubqueryInMerge(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I48((int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "Subquery expressions are not allowed in a MERGE clause.", position);
    }

    public SemanticError invalidUseOfMultiplePathPatterns(boolean matchModeAvailable, InputPosition position) {
        String baseMessage = "Multiple path patterns cannot be used in the same clause in combination with a selective path selector.";
        String action = matchModeAvailable ? " You may want to use multiple MATCH clauses, or you might want to consider using the REPEATABLE ELEMENTS match mode." : "";
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I45((String)action, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, baseMessage + action, position);
    }

    public SemanticError invalidFieldTerminator(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I05).atPosition(position.line(), position.column(), position.offset()).build()).build();
        return new SemanticError(gql, "CSV field terminator can only be one character wide", position);
    }

    public SemanticError singleRelationshipPatternRequired(String name, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.line(), position.column(), position.offset()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N40).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.fun, name).build()).build();
        return new SemanticError(gql, name + "(...) requires a pattern containing a single relationship", position);
    }

    public SemanticError inputContainsInvalidCharacters(String invalidInput, String context, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N82).atPosition(position.line(), position.column(), position.offset()).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError mixingColonAndIs(Set<String> labelExpressions, Set<String> replacements, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I29((String)labelExpressions.mkString(", "), (String)replacements.mkString(", "), (int)position.line(), (int)position.column(), (int)position.offset());
        String exprText = replacements.size() > 1 ? "These expressions" : "This expression";
        return new SemanticError(gql, "Mixing the IS keyword with colon (':') between labels is not allowed. " + exprText + " could be expressed as " + replacements.mkString(", ") + ".", position);
    }

    public SemanticError mixingIsWithMultipleLabels(String statement, String replacement, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I29((String)statement, (String)replacement, (int)position.line(), (int)position.column(), (int)position.offset());
        return new SemanticError(gql, "It is not supported to use the `IS` keyword together with multiple labels in `" + statement + "`. Rewrite the expression as `" + replacement + "`.", position);
    }

    public SemanticError apply(ErrorGqlStatusObject gqlStatusObject, String msg, InputPosition position) {
        return new SemanticError(gqlStatusObject, msg, position);
    }

    public Option<Tuple3<ErrorGqlStatusObject, String, InputPosition>> unapply(SemanticError x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.gqlStatusObject(), (Object)x$0.msg(), (Object)x$0.position()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SemanticError$.class);
    }

    private SemanticError$() {
    }
}

