/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert;

import java.io.IOException;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.internal.BatchInserterImpl;
import org.neo4j.batchinsert.internal.FileSystemClosingBatchInserter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.DatabaseTracers;

public final class BatchInserters {
    public static BatchInserter inserter(DatabaseLayout databaseLayout) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserter batchInserter = BatchInserters.inserter(databaseLayout, (FileSystemAbstraction)fileSystem, Config.defaults());
        return new FileSystemClosingBatchInserter(batchInserter, (FileSystemAbstraction)fileSystem);
    }

    public static BatchInserter inserter(DatabaseLayout databaseLayout, FileSystemAbstraction fs) throws IOException {
        return BatchInserters.inserter(databaseLayout, fs, Config.defaults((Setting)GraphDatabaseSettings.preallocate_logical_logs, (Object)Boolean.FALSE));
    }

    public static BatchInserter inserter(DatabaseLayout databaseLayout, Config config) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserter inserter = BatchInserters.inserter(databaseLayout, (FileSystemAbstraction)fileSystem, config);
        return new FileSystemClosingBatchInserter(inserter, (FileSystemAbstraction)fileSystem);
    }

    public static BatchInserter inserter(DatabaseLayout databaseLayout, FileSystemAbstraction fs, Config config) throws IOException {
        return new BatchInserterImpl(databaseLayout, fs, config, DatabaseTracers.EMPTY);
    }

    private static DefaultFileSystemAbstraction createFileSystem() {
        return new DefaultFileSystemAbstraction();
    }
}

