/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReaderV1;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriterV1;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.logging.internal.LogService;

public class BoltProtocolV1
implements BoltProtocol {
    public static final long VERSION = 1L;
    private final Neo4jPack neo4jPack;
    private final BoltConnection connection;
    private final BoltRequestMessageReader messageReader;
    private final BoltChannel channel;
    private final LogService logging;

    public BoltProtocolV1(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, LogService logging) {
        this.channel = channel;
        this.logging = logging;
        BoltStateMachine stateMachine = stateMachineFactory.newStateMachine(this.version(), channel);
        this.connection = connectionFactory.newConnection(channel, stateMachine);
        this.neo4jPack = this.createPack();
        this.messageReader = this.createMessageReader(channel, this.neo4jPack, this.connection, logging);
    }

    @Override
    public void install() {
        ChannelPipeline pipeline = this.channel.rawChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChunkDecoder()});
        pipeline.addLast(new ChannelHandler[]{new MessageAccumulator()});
        pipeline.addLast(new ChannelHandler[]{new MessageDecoder(this.neo4jPack, this.messageReader, this.logging)});
        pipeline.addLast(new ChannelHandler[]{new HouseKeeper(this.connection, this.logging.getInternalLog(HouseKeeper.class))});
    }

    protected Neo4jPack createPack() {
        return new Neo4jPackV1();
    }

    @Override
    public long version() {
        return 1L;
    }

    protected BoltRequestMessageReader createMessageReader(BoltChannel channel, Neo4jPack neo4jPack, BoltConnection connection, LogService logging) {
        BoltResponseMessageWriterV1 responseWriter = new BoltResponseMessageWriterV1(neo4jPack, connection.output(), logging);
        return new BoltRequestMessageReaderV1(connection, responseWriter, logging);
    }
}

