/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.StateMachineContext;

public class BoltStateMachineV1Context
implements StateMachineContext {
    private final BoltStateMachine machine;
    private final BoltChannel boltChannel;
    private final BoltStateMachineSPI spi;
    private final MutableConnectionState connectionState;
    private final Clock clock;

    public BoltStateMachineV1Context(BoltStateMachine machine, BoltChannel boltChannel, BoltStateMachineSPI spi, MutableConnectionState connectionState, Clock clock) {
        this.machine = machine;
        this.boltChannel = boltChannel;
        this.spi = spi;
        this.connectionState = connectionState;
        this.clock = clock;
    }

    @Override
    public void authenticatedAsUser(String username, String userAgent) {
        this.boltChannel.updateUser(username, userAgent);
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        this.machine.handleFailure(cause, fatal);
    }

    @Override
    public boolean resetMachine() throws BoltConnectionFatality {
        return this.machine.reset();
    }

    @Override
    public BoltStateMachineSPI boltSpi() {
        return this.spi;
    }

    @Override
    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public String connectionId() {
        return this.machine.id();
    }
}

