/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.regex.Pattern;
import org.neo4j.bolt.v1.messaging.request.RunMessage;

final class RunMessageChecker {
    private static final Pattern BEGIN = Pattern.compile("(?i)^\\s*BEGIN\\s*;?\\s*$");
    private static final Pattern COMMIT = Pattern.compile("(?i)^\\s*COMMIT\\s*;?\\s*$");
    private static final Pattern ROLLBACK = Pattern.compile("(?i)^\\s*ROLLBACK\\s*;?\\s*$");

    private RunMessageChecker() {
    }

    static boolean isBegin(RunMessage message) {
        return RunMessageChecker.matches(message, BEGIN);
    }

    static boolean isCommit(RunMessage message) {
        return RunMessageChecker.matches(message, COMMIT);
    }

    static boolean isRollback(RunMessage message) {
        return RunMessageChecker.matches(message, ROLLBACK);
    }

    private static boolean matches(RunMessage message, Pattern pattern) {
        return pattern.matcher(message.statement()).matches();
    }
}

