/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1;
import org.neo4j.bolt.v3.runtime.ConnectedState;
import org.neo4j.bolt.v3.runtime.FailedState;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.bolt.v3.runtime.StreamingState;
import org.neo4j.bolt.v3.runtime.TransactionReadyState;
import org.neo4j.bolt.v3.runtime.TransactionStreamingState;

public class BoltStateMachineV3
extends BoltStateMachineV1 {
    public BoltStateMachineV3(BoltStateMachineSPI boltSPI, BoltChannel boltChannel, Clock clock) {
        super(boltSPI, boltChannel, clock);
    }

    @Override
    protected BoltStateMachineV1.States buildStates() {
        ConnectedState connected = new ConnectedState();
        ReadyState ready = new ReadyState();
        StreamingState streaming = new StreamingState();
        TransactionReadyState txReady = new TransactionReadyState();
        TransactionStreamingState txStreaming = new TransactionStreamingState();
        FailedState failed = new FailedState();
        InterruptedState interrupted = new InterruptedState();
        connected.setReadyState(ready);
        ready.setTransactionReadyState(txReady);
        ready.setStreamingState(streaming);
        ready.setFailedState(failed);
        ready.setInterruptedState(interrupted);
        streaming.setReadyState(ready);
        streaming.setFailedState(failed);
        streaming.setInterruptedState(interrupted);
        txReady.setReadyState(ready);
        txReady.setTransactionStreamingState(txStreaming);
        txReady.setFailedState(failed);
        txReady.setInterruptedState(interrupted);
        txStreaming.setReadyState(txReady);
        txStreaming.setFailedState(failed);
        txStreaming.setInterruptedState(interrupted);
        failed.setInterruptedState(interrupted);
        interrupted.setReadyState(ready);
        return new BoltStateMachineV1.States(connected, failed);
    }

    @Override
    protected void after() {
        if (this.connectionState.isTerminated()) {
            this.close();
        } else {
            super.after();
        }
    }
}

