/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.executor;

import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.protocol.common.connector.executor.ExecutorServiceFactory;
import org.neo4j.util.VisibleForTesting;

public class ThreadPoolExecutorServiceFactory
implements ExecutorServiceFactory {
    @VisibleForTesting
    static final int UNBOUNDED_QUEUE = -1;
    @VisibleForTesting
    static final int SYNCHRONOUS_QUEUE = 0;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final boolean prestartCoreThreads;
    private final Duration keepAlive;
    private final int queueSize;
    private final ThreadFactory threadFactory;

    public ThreadPoolExecutorServiceFactory(int corePoolSize, int maxPoolSize, boolean prestartCoreThreads, Duration keepAlive, int queueSize, ThreadFactory threadFactory) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.prestartCoreThreads = prestartCoreThreads;
        this.keepAlive = keepAlive;
        this.queueSize = queueSize;
        this.threadFactory = threadFactory;
    }

    @Override
    public ExecutorService create() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAlive.toMillis(), TimeUnit.MILLISECONDS, ThreadPoolExecutorServiceFactory.createTaskQueue(this.queueSize), this.threadFactory, new ThreadPoolExecutor.AbortPolicy());
        if (this.prestartCoreThreads) {
            executor.prestartAllCoreThreads();
        }
        return executor;
    }

    private static BlockingQueue<Runnable> createTaskQueue(int queueSize) {
        if (queueSize < -1) {
            throw new IllegalArgumentException(String.format("Unsupported queue size %d for thread pool creation.", queueSize));
        }
        return switch (queueSize) {
            case -1 -> new LinkedBlockingQueue();
            case 0 -> new SynchronousQueue();
            default -> new ArrayBlockingQueue(queueSize);
        };
    }
}

