/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm;

import java.time.Clock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.MutableConnectionState;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContextImpl;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.memory.MemoryTracker;

public abstract class AbstractStateMachine
implements StateMachine {
    private final Connection connection;
    private final StateMachineSPI spi;
    protected final MutableConnectionState connectionState;
    private final StateMachineContext context;
    private State state;
    private final State failedState;
    private final State interruptedState;

    public AbstractStateMachine(StateMachineSPI spi, Connection connection, Clock clock) {
        connection.memoryTracker().allocateHeap(StateMachineContextImpl.SHALLOW_SIZE);
        this.connection = connection;
        this.spi = spi;
        this.connectionState = new MutableConnectionState();
        this.context = new StateMachineContextImpl(connection, this, spi, this.connectionState, clock);
        States states = this.buildStates(connection.memoryTracker());
        this.state = states.initial;
        this.failedState = states.failed;
        this.interruptedState = states.interrupted;
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    @Override
    public void process(RequestMessage message, ResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (message.safeToProcessInAnyState() || this.connectionState.canProcessMessage()) {
                this.nextState(message, this.context);
            }
        }
        finally {
            this.after();
        }
    }

    private void before(ResponseHandler handler) throws BoltConnectionFatality {
        if (this.connection.isInterrupted()) {
            this.state = this.interruptedState;
        }
        this.connectionState.setResponseHandler(handler);
    }

    protected void after() {
        if (this.connectionState.getResponseHandler() != null) {
            try {
                Error pendingError = this.connectionState.getPendingError();
                if (pendingError != null) {
                    this.connectionState.getResponseHandler().onFailure(pendingError);
                } else if (this.connectionState.hasPendingIgnore()) {
                    this.connectionState.getResponseHandler().onIgnored();
                } else {
                    this.connectionState.getResponseHandler().onSuccess();
                }
                this.connectionState.resetPendingFailedAndIgnored();
            }
            finally {
                this.connectionState.setResponseHandler(null);
            }
        }
    }

    private void nextState(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        State preState = this.state;
        this.state = this.state.process(message, context);
        if (this.state == null) {
            String msg = "Message '" + message + "' cannot be handled by a session in the " + preState.name() + " state.";
            this.fail(Error.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }
    }

    @Override
    public void markFailed(Error error) {
        this.fail(error);
        this.state = this.failedState;
    }

    @Override
    public void validateTransaction() throws KernelException {
        Transaction tx = this.connection.transaction().orElse(null);
        if (tx == null) {
            return;
        }
        tx.validate().ifPresent(this.connectionState::setPendingTerminationNotice);
    }

    @Override
    public void handleExternalFailure(Error error, ResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (this.connectionState.canProcessMessage()) {
                this.fail(error);
                this.state = this.failedState;
            }
        }
        finally {
            this.after();
        }
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        if (ExceptionUtils.indexOfType((Throwable)cause, BoltConnectionFatality.class) != -1) {
            fatal = true;
        }
        Error error = fatal ? Error.fatalFrom(cause) : Error.from(cause);
        this.fail(error);
        if (error.isFatal()) {
            if (ExceptionUtils.indexOfType((Throwable)cause, AuthorizationExpiredException.class) != -1) {
                throw new BoltConnectionAuthFatality("Failed to process a bolt message", cause);
            }
            if (cause instanceof AuthenticationException) {
                throw new BoltConnectionAuthFatality((AuthenticationException)cause);
            }
            throw new BoltConnectionFatality("Failed to process a bolt message", cause);
        }
    }

    public State state() {
        return this.state;
    }

    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    public StateMachineContext stateMachineContext() {
        return this.context;
    }

    private void fail(Error error) {
        this.spi.reportError(error);
        if (this.state == this.failedState) {
            this.connectionState.markIgnored();
        } else {
            this.connectionState.markFailed(error);
        }
    }

    protected abstract States buildStates(MemoryTracker var1);

    public record States(State initial, State failed, State interrupted) {
    }
}

