/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.request.authentication;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;

public final class HelloMessage
implements RequestMessage {
    public static final byte SIGNATURE = 1;
    private final String userAgent;
    private final List<Feature> features;
    private final RoutingContext routingContext;
    private final Map<String, Object> authToken;
    private final NotificationsConfig notificationsConfig;
    private final Map<String, String> boltAgent;

    public HelloMessage(String userAgent, List<Feature> features, RoutingContext routingContext, Map<String, Object> authToken, NotificationsConfig notificationsConfig, Map<String, String> boltAgent) {
        this.userAgent = userAgent;
        this.features = features;
        this.routingContext = routingContext;
        this.authToken = authToken;
        this.notificationsConfig = notificationsConfig;
        this.boltAgent = boltAgent;
    }

    public HelloMessage(String userAgent, List<Feature> features, RoutingContext routingContext, Map<String, Object> authToken) {
        this(userAgent, features, routingContext, authToken, null, null);
    }

    public Map<String, Object> authToken() {
        return this.authToken;
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public Map<String, String> boltAgent() {
        return this.boltAgent;
    }

    public List<Feature> features() {
        return this.features;
    }

    public NotificationsConfig notificationsConfig() {
        return this.notificationsConfig;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        return Objects.equals(this.userAgent, that.userAgent) && Objects.equals(this.boltAgent, that.boltAgent) && Objects.equals(this.features, that.features) && Objects.equals(this.authToken, that.authToken) && Objects.equals(this.routingContext, that.routingContext) && Objects.equals(this.notificationsConfig, that.notificationsConfig);
    }

    public int hashCode() {
        return Objects.hash(this.userAgent, this.features, this.authToken, this.routingContext);
    }

    public String toString() {
        String notifications = this.notificationsConfig != null ? this.notificationsConfig.toString() : "null";
        return "HelloMessage{userAgent='" + this.userAgent + "', features=" + this.features + ", boltAgent=" + this.boltAgent + ", authToken=" + this.authToken + ", routingContext=" + this.routingContext + ", notificationsConfig=" + notifications + "}";
    }
}

