/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.codec.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class ChunkFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MAX_CHUNK_LENGTH = 65535;
    private final int limit;

    public ChunkFrameEncoder(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be positive");
        }
        this.limit = limit;
    }

    public ChunkFrameEncoder() {
        this(65535);
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        if (!msg.isReadable()) {
            return;
        }
        while (msg.isReadable()) {
            int chunkLength = Math.min(this.limit, msg.readableBytes());
            out.writeShort(chunkLength);
            if (chunkLength == 0) continue;
            out.writeBytes(msg, chunkLength);
        }
    }
}

