/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector;

import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public class ConnectionRegistry {
    private final String connectorId;
    private final NetworkConnectionTracker connectionTracker;
    private final InternalLog log;
    private final Deque<Connection> connections = new ConcurrentLinkedDeque<Connection>();

    public ConnectionRegistry(String connectorId, NetworkConnectionTracker connectionTracker, InternalLogProvider logging) {
        this.connectorId = connectorId;
        this.connectionTracker = connectionTracker;
        this.log = logging.getLog(ConnectionRegistry.class);
    }

    public String allocateId() {
        return this.connectionTracker.newConnectionId(this.connectorId);
    }

    public void register(Connection connection) {
        this.connections.add(connection);
        if (this.connectionTracker != null) {
            this.connectionTracker.add((TrackedNetworkConnection)connection);
        }
        this.log.debug("[%s] Registered connection", new Object[]{connection.id()});
    }

    public void unregister(Connection connection) {
        this.connections.remove(connection);
        if (this.connectionTracker != null) {
            this.connectionTracker.remove((TrackedNetworkConnection)connection);
        }
        this.log.debug("[%s] Removed connection", new Object[]{connection.id()});
    }

    public void stopIdling() {
        Iterator<Connection> it = this.connections.iterator();
        this.log.info("Stopping remaining idle connections for connector %s", new Object[]{this.connectorId});
        int n = 0;
        while (it.hasNext()) {
            Connection connection = it.next();
            if (!connection.isIdling()) continue;
            this.log.debug("[%s] Stopping idle connection", new Object[]{connection.id()});
            connection.close();
            try {
                connection.closeFuture().get();
            }
            catch (InterruptedException ex) {
                this.log.warn("[" + connection.id() + "] Interrupted while awaiting clean shutdown of connection", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                this.log.warn("[" + connection.id() + "] Clean shutdown of connection has failed", (Throwable)ex);
            }
            it.remove();
            if (this.connectionTracker != null) {
                this.connectionTracker.remove((TrackedNetworkConnection)connection);
            }
            ++n;
            this.log.debug("[%s] Stopped idle connection", new Object[]{connection.id()});
        }
        this.log.info("Stopped %d idling connections for connector %s", new Object[]{n, this.connectorId});
    }

    public void stopAll() {
        this.log.info("Stopping %d connections for connector %s", new Object[]{this.connections.size(), this.connectorId});
        this.connections.forEach(connection -> {
            this.log.debug("[%s] Stopping connection", new Object[]{connection.id()});
            connection.close();
            try {
                connection.closeFuture().get();
            }
            catch (InterruptedException ex) {
                this.log.warn("[" + connection.id() + "] Interrupted while awaiting clean shutdown of connection", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                this.log.warn("[" + connection.id() + "] Clean shutdown of connection has failed", (Throwable)ex);
            }
            if (this.connectionTracker != null) {
                this.connectionTracker.remove((TrackedNetworkConnection)connection);
            }
            this.log.debug("[%s] Stopped connection", new Object[]{connection.id()});
        });
        this.connections.clear();
        this.log.info("Stopped all remaining connections for connector %s", new Object[]{this.connectorId});
    }
}

