/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.time.Duration;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.handler.AuthenticationTimeoutHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class AuthenticationTimeoutConnectionListener
implements ConnectionListener {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AuthenticationTimeoutConnectionListener.class);
    private final Connection connection;
    private final Duration timeout;
    private final InternalLog log;
    private volatile AuthenticationTimeoutHandler handler;

    public AuthenticationTimeoutConnectionListener(Connection connection, Duration timeout, InternalLogProvider logging) {
        this.connection = connection;
        this.timeout = timeout;
        this.log = logging.getLog(AuthenticationTimeoutConnectionListener.class);
    }

    @Override
    public void onListenerRemoved() {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    @Override
    public void onNetworkPipelineInitialized(ChannelPipeline pipeline) {
        this.log.debug("[%s] Installing authentication timeout handler", new Object[]{this.connection.id()});
        this.connection.memoryTracker().allocateHeap(AuthenticationTimeoutHandler.SHALLOW_SIZE);
        this.handler = new AuthenticationTimeoutHandler(this.timeout);
        pipeline.addLast(new ChannelHandler[]{this.handler});
    }

    @Override
    public void onRequestReceived(RequestMessage message) {
        if (this.handler != null) {
            this.log.debug("[%s] Received request during authentication phase", new Object[]{this.connection.id()});
            this.handler.setRequestReceived(true);
        }
    }

    @Override
    public void onLogon(LoginContext ctx) {
        this.log.debug("[%s] Removing authentication timeout handler", new Object[]{this.connection.id()});
        if (this.handler != null) {
            this.connection.channel().pipeline().remove((ChannelHandler)this.handler);
            this.handler = null;
        }
    }

    @Override
    public void onLogoff() {
        this.log.debug("[%s] Re-adding authentication timeout handler", new Object[]{this.connection.id()});
        this.connection.memoryTracker().allocateHeap(AuthenticationTimeoutHandler.SHALLOW_SIZE);
        this.handler = new AuthenticationTimeoutHandler(this.timeout);
        this.connection.channel().pipeline().addBefore("housekeeper", "authenticationTimeoutHandler", (ChannelHandler)this.handler);
    }
}

