/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.listener;

import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.KeepAliveConnectionListener;
import org.neo4j.bolt.protocol.common.connector.listener.ConnectorListener;
import org.neo4j.logging.InternalLogProvider;

public class KeepAliveConnectorListener
implements ConnectorListener {
    private final boolean legacyMode;
    private final long writeIdleTime;
    private final InternalLogProvider logging;

    public KeepAliveConnectorListener(boolean legacyMode, long writeIdleTime, InternalLogProvider logging) {
        this.legacyMode = legacyMode;
        this.writeIdleTime = writeIdleTime;
        this.logging = logging;
    }

    @Override
    public void onConnectionCreated(Connection connection) {
        connection.memoryTracker().allocateHeap(KeepAliveConnectionListener.SHALLOW_SIZE);
        connection.registerListener(new KeepAliveConnectionListener(connection, this.legacyMode, this.writeIdleTime, this.logging));
    }
}

