/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.util.Objects;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.configuration.SettingBuilder;
import org.neo4j.configuration.SettingConstraint;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;

public abstract class StorageSettingsDeclaration
implements SettingsDeclaration {
    public static final long DOWNLOAD_CHUNK_SIZE = ByteUnit.mebiBytes((long)8L);
    public static final String READ_IS_FOR_SAMPLING_FLAG = "cloud.storage.read.sampling";
    private static final SettingConstraint<Long> CHUNK_RANGE = SettingConstraints.range((Comparable)Long.valueOf(ByteUnit.mebiBytes((long)1L)), (Comparable)Long.valueOf(ByteUnit.gibiBytes((long)1L)));
    static final String INTERNAL_CONFIG_PREFIX = "internal.dbms.cloud.storage";

    public static StoragePath adaptPathForSampling(StoragePath path) {
        return path.copy().addMetadata(READ_IS_FOR_SAMPLING_FLAG, Boolean.TRUE);
    }

    public static Setting<Integer> pushQueueSlotSize(StoragePath path) {
        return StorageSettingsDeclaration.pushQueueSlotSize(StorageSettingsDeclaration.scheme(path));
    }

    public static Setting<Long> pushQueueChunkSize(StoragePath path) {
        return StorageSettingsDeclaration.pushQueueChunkSize(StorageSettingsDeclaration.scheme(path));
    }

    public static Setting<Integer> pullQueueSlotSize(StoragePath path) {
        return StorageSettingsDeclaration.pullQueueSlotSize(StorageSettingsDeclaration.scheme(path));
    }

    public static Setting<Long> pullQueueChunkSize(StoragePath path) {
        return StorageSettingsDeclaration.pullQueueChunkSize(StorageSettingsDeclaration.scheme(path));
    }

    protected static Setting<Integer> pushQueueSlotSize(String scheme) {
        return StorageSettingsDeclaration.queueOption(scheme, "push", "slot", SettingValueParsers.INT, 64).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(16))).build();
    }

    protected static Setting<Long> pushQueueChunkSize(String scheme) {
        return StorageSettingsDeclaration.queueOption(scheme, "push", "chunk", SettingValueParsers.BYTES, DOWNLOAD_CHUNK_SIZE).addConstraint(CHUNK_RANGE).build();
    }

    protected static Setting<Integer> pullQueueSlotSize(String scheme) {
        return StorageSettingsDeclaration.queueOption(scheme, "pull", "slot", SettingValueParsers.INT, StorageSettingsDeclaration.defaultPullQueueSize()).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(1))).build();
    }

    protected static Setting<Long> pullQueueChunkSize(String scheme) {
        return StorageSettingsDeclaration.queueOption(scheme, "pull", "chunk", SettingValueParsers.BYTES, DOWNLOAD_CHUNK_SIZE).addConstraint(CHUNK_RANGE).build();
    }

    protected static <S> SettingBuilder<S> publicOption(String scheme, String optionName, SettingValueParser<S> parser, S defaultValue) {
        return SettingImpl.newBuilder((String)"dbms.integrations.cloud_storage.%s.%s".formatted(scheme, optionName), parser, defaultValue);
    }

    protected static <S> SettingBuilder<S> internalOption(String scheme, String optionName, SettingValueParser<S> parser, S defaultValue) {
        return SettingImpl.newBuilder((String)"%s.%s.%s".formatted(INTERNAL_CONFIG_PREFIX, scheme, optionName), parser, defaultValue);
    }

    private static <S> SettingBuilder<S> queueOption(String scheme, String queueType, String optionType, SettingValueParser<S> parser, S defaultValue) {
        return StorageSettingsDeclaration.internalOption(scheme, "%s_queue_%s_size".formatted(queueType, optionType), parser, defaultValue);
    }

    private static String scheme(StoragePath path) {
        return Objects.requireNonNull(path).scheme();
    }

    private static int defaultPullQueueSize() {
        return Math.max(4, Integer.highestOneBit(Runtime.getRuntime().availableProcessors() / 6) << 1);
    }
}

