/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.queues;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.neo4j.cloud.storage.queues.RequestQueueConfigs;
import org.neo4j.util.Preconditions;

public abstract class RequestQueue
implements AutoCloseable {
    private final Queue<CompletableFuture<ByteBuffer>> queue;
    private final RequestQueueConfigs.QueueConfig queueConfig;
    private final long objectSize;
    private long nextRequestPosition;

    protected RequestQueue(RequestQueueConfigs.QueueConfig queueConfig, long objectSize, long startPosition) {
        this.queueConfig = Objects.requireNonNull(queueConfig);
        this.objectSize = Preconditions.requirePositive((long)objectSize);
        this.nextRequestPosition = Preconditions.requireNonNegative((long)startPosition);
        this.queue = new ArrayDeque<CompletableFuture<ByteBuffer>>(queueConfig.queueSize());
    }

    protected abstract CompletableFuture<ByteBuffer> get(long var1, long var3);

    @Override
    public void close() {
        this.clearQueue();
    }

    protected final RequestQueueConfigs.QueueConfig queueConfig() {
        return this.queueConfig;
    }

    protected final long getObjectSize() {
        return this.objectSize;
    }

    protected final int queueSize() {
        return this.queue.size();
    }

    protected final long nextRequestPosition() {
        return this.nextRequestPosition;
    }

    protected final void setNextRequestPosition(long nextRequestPosition) {
        this.nextRequestPosition = Preconditions.requireNonNegative((long)nextRequestPosition);
    }

    protected final void fillQueue() {
        for (int i = this.queueSize(); i < this.queueConfig().queueSize() && this.maybeRequestChunk(); ++i) {
        }
    }

    protected final CompletableFuture<ByteBuffer> poll(boolean preloadNextRequests) {
        CompletableFuture<ByteBuffer> next = this.queue.poll();
        if (next != null && preloadNextRequests) {
            this.fillQueue();
        }
        return next;
    }

    protected final void clearQueue() {
        for (CompletableFuture completableFuture : this.queue) {
            completableFuture.cancel(true);
        }
        this.queue.clear();
    }

    protected final boolean maybeRequestChunk() {
        long rangeStart = this.nextRequestPosition;
        if (rangeStart >= this.objectSize) {
            return false;
        }
        this.nextRequestPosition += (long)this.queueConfig.chunkSize();
        this.queue.offer(this.request(rangeStart));
        return true;
    }

    protected void onBeforeLoad(long from, long to) {
    }

    private CompletableFuture<ByteBuffer> request(long from) {
        long end = Math.min(from + (long)this.queueConfig.chunkSize(), this.objectSize);
        this.onBeforeLoad(from, end);
        return this.get(from, end);
    }
}

