/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.diffset;

import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.diffset.RemovalsCountingDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class ChangeCountingDiffSet
extends RemovalsCountingDiffSets {
    private static final long CHANGE_COUNTING_DIFF_SET_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ChangeCountingDiffSet.class);
    private final CollectionsFactory collectionsFactory;
    private final MemoryTracker memoryTracker;
    private MutableLongSet changed;

    static ChangeCountingDiffSet newRemovalsCountingDiffSets(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(CHANGE_COUNTING_DIFF_SET_SHALLOW_SIZE);
        return new ChangeCountingDiffSet(collectionsFactory, memoryTracker);
    }

    private ChangeCountingDiffSet(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        super(collectionsFactory, memoryTracker);
        this.collectionsFactory = collectionsFactory;
        this.memoryTracker = memoryTracker;
    }

    public LongSet getChanged() {
        return this.changed != null ? this.changed : LongSets.immutable.empty();
    }

    public void change(long element) {
        assert (!this.isAdded(element));
        assert (!this.isRemoved(element));
        if (this.changed == null) {
            this.changed = this.collectionsFactory.newLongSet(this.memoryTracker);
        }
        this.changed.add(element);
    }

    public void unchange(long element) {
        assert (!this.isAdded(element));
        assert (!this.isRemoved(element));
        if (this.changed != null) {
            this.changed.remove(element);
        }
    }

    @Override
    public boolean remove(long elem) {
        if (this.changed != null) {
            this.changed.remove(elem);
        }
        return super.remove(elem);
    }
}

