/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class CastingIterator<T extends A, A>
extends PrefetchingIterator<T> {
    private final Iterator<A> source;
    private Class<T> outClass;

    public CastingIterator(Iterator<A> source, Class<T> outClass) {
        this.source = source;
        this.outClass = outClass;
    }

    @Override
    protected T fetchNextOrNull() {
        while (this.source.hasNext()) {
            A testItem = this.source.next();
            if (!this.outClass.isInstance(testItem)) continue;
            return this.outClass.cast(testItem);
        }
        return null;
    }
}

