/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.collections.impl.utility.MapIterate;
import org.neo4j.collection.trackable.AbstractHeapTrackingConcurrentHash;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class HeapTrackingConcurrentHashMap<K, V>
extends AbstractHeapTrackingConcurrentHash
implements ConcurrentMap<K, V>,
AutoCloseable {
    private static final long SHALLOW_SIZE_THIS = HeapEstimator.shallowSizeOfInstance(HeapTrackingConcurrentHashMap.class);
    private static final long SHALLOW_SIZE_WRAPPER = HeapEstimator.shallowSizeOfInstance(Entry.class);

    public static <K, V> HeapTrackingConcurrentHashMap<K, V> newMap(MemoryTracker memoryTracker) {
        return HeapTrackingConcurrentHashMap.newMap(memoryTracker, 16);
    }

    public static <K, V> HeapTrackingConcurrentHashMap<K, V> newMap(MemoryTracker memoryTracker, int size) {
        memoryTracker.allocateHeap(SHALLOW_SIZE_THIS);
        return new HeapTrackingConcurrentHashMap<K, V>(memoryTracker, size);
    }

    @Override
    public long sizeOfWrapperObject() {
        return SHALLOW_SIZE_WRAPPER;
    }

    private HeapTrackingConcurrentHashMap(MemoryTracker memoryTracker, int initialCapacity) {
        super(memoryTracker, initialCapacity);
    }

    @Override
    public V put(K key, V value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            Entry<K, V> newEntry = new Entry<K, V>(key, value, null);
            this.addToSize(1);
            if (currentArray.compareAndSet(index, null, newEntry)) {
                return null;
            }
            this.addToSize(-1);
        }
        return this.slowPut(key, value, hash, currentArray);
    }

    private V slowPut(K key, V value, int hash, AtomicReferenceArray<Object> currentArray) {
        int length;
        Object o;
        block0: while (true) {
            int index;
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                Object candidate = ((Entry)e).getKey();
                if (!candidate.equals(key)) continue;
                Object oldValue = ((Entry)e).getValue();
                Entry newEntry = new Entry(((Entry)e).getKey(), value, this.createReplacementChainForRemoval((Entry)o, (Entry<K, V>)e));
                if (!currentArray.compareAndSet(index, o, newEntry)) continue block0;
                return oldValue;
            }
            Entry<K, V> newEntry = new Entry<K, V>(key, value, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return null;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int length;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray<Object> currentArray = this.table;
        while (true) {
            int index;
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                Object candidate = ((Entry)e).getKey();
                if (!candidate.equals(key)) continue;
                return ((Entry)e).getValue();
            }
            Entry<K, V> newEntry = new Entry<K, V>(key, value, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        int length;
        int index;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray<Object> currentArray = this.table;
        while (true) {
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                Object candidate = ((Entry)e).getKey();
                if (!candidate.equals(key)) continue;
                return ((Entry)e).getValue();
            }
            if (currentArray.compareAndSet(index, o, RESERVED)) break;
        }
        try {
            newValue = mappingFunction.apply(key);
        }
        catch (Exception exception) {
            currentArray.compareAndSet(index, RESERVED, o);
            throw exception;
        }
        if (newValue == null) {
            currentArray.compareAndSet(index, RESERVED, o);
            return null;
        }
        Entry<K, V> newEntry = new Entry<K, V>(key, newValue, (Entry)o);
        currentArray.set(index, newEntry);
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return newValue;
    }

    public Iterator<V> iterator() {
        return this.values().iterator();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Set<Map.Entry<K, V>> entries = this.entrySet();
        for (Map.Entry<K, V> entry : entries) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public void forEachValue(Consumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Collection<V> entries = this.values();
        for (V value : entries) {
            action.accept(value);
        }
    }

    @Override
    void transfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        int j = 0;
        while (j < src.length() - 1) {
            Object o = HeapTrackingConcurrentHashMap.getAtIndex(src, j);
            if (o == null) {
                if (!src.compareAndSet(j, null, RESIZED)) continue;
                ++j;
                continue;
            }
            if (o == RESIZED || o == RESIZING) {
                j = (j & -AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT) + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
                if (resizeContainer.resizers.get() != 1) continue;
                break;
            }
            if (!src.compareAndSet(j, o, RESIZING)) continue;
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                this.unconditionalCopy(dest, (Entry<K, V>)e);
            }
            src.set(j, RESIZED);
            ++j;
        }
        resizeContainer.decrementResizerAndNotify();
        resizeContainer.waitForAllResizers();
    }

    @Override
    void reverseTransfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        while (resizeContainer.getQueuePosition() > 0) {
            int start = resizeContainer.subtractAndGetQueuePosition();
            int end = start + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
            if (end <= 0) continue;
            if (start < 0) {
                start = 0;
            }
            int j = end - 1;
            while (j >= start) {
                Object o = HeapTrackingConcurrentHashMap.getAtIndex(src, j);
                if (o == null) {
                    if (!src.compareAndSet(j, null, RESIZED)) continue;
                    --j;
                    continue;
                }
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer.zeroOutQueuePosition();
                    return;
                }
                if (!src.compareAndSet(j, o, RESIZING)) continue;
                for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                    this.unconditionalCopy(dest, (Entry<K, V>)e);
                }
                src.set(j, RESIZED);
                --j;
            }
        }
    }

    private void unconditionalCopy(AtomicReferenceArray<Object> dest, Entry<K, V> toCopyEntry) {
        int hash = this.hash(toCopyEntry.getKey());
        AtomicReferenceArray<Object> currentArray = dest;
        while (true) {
            int length;
            int index;
            Object o;
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = ((AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get((int)(length - 1))).nextArray;
                continue;
            }
            Entry<K, V> newEntry = o == null ? (toCopyEntry.getNext() == null ? toCopyEntry : new Entry<K, V>(toCopyEntry.getKey(), toCopyEntry.getValue())) : new Entry<K, V>(toCopyEntry.getKey(), toCopyEntry.getValue(), (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean remove(Object key, Object value) {
        hash = this.hash(key);
        currentArray = this.table;
        block0: while (true) {
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == HeapTrackingConcurrentHashMap.RESIZED || o == HeapTrackingConcurrentHashMap.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (Entry)o; e != null; e = e.getNext()) {
                candidate = e.getKey();
                if (!candidate.equals(key) || !Objects.equals(e.getValue(), value)) continue;
                replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<K, V>)e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return true;
            }
            break;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer;
        AtomicReferenceArray<Object> currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                    Object v = ((Entry)e).getValue();
                    if (!Objects.equals(v, value)) continue;
                    return true;
                }
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
        return false;
    }

    @Override
    public V get(Object key) {
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = HeapTrackingConcurrentHashMap.indexFor(hash, currentArray.length());
        Object o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowGet(key, hash, currentArray);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            Object k = ((Entry)e).key;
            if (k != key && !key.equals(k)) continue;
            return ((Entry)e).value;
        }
        return null;
    }

    private V slowGet(Object key, int hash, AtomicReferenceArray<Object> currentArray) {
        int length;
        int index;
        Object o;
        while ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            Object candidate = ((Entry)e).getKey();
            if (!candidate.equals(key)) continue;
            return ((Entry)e).getValue();
        }
        return null;
    }

    private Entry<K, V> getEntry(Object key) {
        int length;
        int index;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray<Object> currentArray = this.table;
        while ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            Object candidate = ((Entry)e).getKey();
            if (!candidate.equals(key)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map);
        MapIterate.forEachKeyValue(map, this::put);
    }

    @Override
    public void clear() {
        AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer;
        AtomicReferenceArray<Object> currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                if (!currentArray.compareAndSet(i, o, null)) continue;
                int removedEntries = 0;
                for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                    ++removedEntries;
                }
                this.addToSize(-removedEntries);
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowReplace(key, oldValue, newValue, hash, currentArray);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            Object candidate = ((Entry)e).getKey();
            if (candidate != key && !candidate.equals(key)) continue;
            if (oldValue == ((Entry)e).getValue() || oldValue != null && oldValue.equals(((Entry)e).getValue())) {
                Entry<K, V> replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<K, V>)e);
                Entry<K, V> newEntry = new Entry<K, V>(key, newValue, replacement);
                return currentArray.compareAndSet(index, o, newEntry) || this.slowReplace(key, oldValue, newValue, hash, currentArray);
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean slowReplace(K key, V oldValue, V newValue, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            int length;
            int index;
            Object o;
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                Object candidate = ((Entry)e).getKey();
                if (candidate != key && !candidate.equals(key)) continue;
                if (oldValue != ((Entry)e).getValue() && (oldValue == null || !oldValue.equals(((Entry)e).getValue()))) return false;
                Entry<K, V> replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<K, V>)e);
                Entry<K, V> newEntry = new Entry<K, V>(key, newValue, replacement);
                if (currentArray.compareAndSet(index, o, newEntry)) return true;
                continue block0;
            }
            break;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            return null;
        }
        return this.slowReplace(key, value, hash, currentArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private V slowReplace(K key, V value, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            int length;
            int index;
            Object o;
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                Object candidate = ((Entry)e).getKey();
                if (!candidate.equals(key)) continue;
                Object oldValue = ((Entry)e).getValue();
                Entry newEntry = new Entry(((Entry)e).getKey(), value, this.createReplacementChainForRemoval((Entry)o, (Entry<K, V>)e));
                if (currentArray.compareAndSet(index, o, newEntry)) return oldValue;
                continue block0;
            }
            break;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowRemove(key, hash, currentArray);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            Object candidate = ((Entry)e).getKey();
            if (!candidate.equals(key)) continue;
            Entry<K, V> replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<K, V>)e);
            if (currentArray.compareAndSet(index, o, replacement)) {
                this.addToSize(-1);
                return ((Entry)e).getValue();
            }
            return this.slowRemove(key, hash, currentArray);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private V slowRemove(Object key, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            if ((o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == HeapTrackingConcurrentHashMap.RESIZED || o == HeapTrackingConcurrentHashMap.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (Entry)o; e != null; e = e.getNext()) {
                candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<K, V>)e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return e.getValue();
            }
            break;
        }
        return null;
    }

    private Entry<K, V> createReplacementChainForRemoval(Entry<K, V> original, Entry<K, V> toRemove) {
        if (original == toRemove) {
            return original.getNext();
        }
        Entry replacement = null;
        for (Object e = original; e != null; e = ((Entry)e).getNext()) {
            if (e == toRemove) continue;
            replacement = new Entry(((Entry)e).getKey(), ((Entry)e).getValue(), replacement);
        }
        return replacement;
    }

    @Override
    public int hashCode() {
        int h = 0;
        AtomicReferenceArray currentArray = this.table;
        for (int i = 0; i < currentArray.length() - 1; ++i) {
            Object o = HeapTrackingConcurrentHashMap.getAtIndex(currentArray, i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't compute hashcode while resizing!");
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                Object key = ((Entry)e).getKey();
                Object value = ((Entry)e).getValue();
                h += (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        for (Map.Entry<K, V> e : this.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = iterator.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE_THIS);
        this.releaseHeap();
    }

    private static final class Entry<K, V>
    implements Map.Entry<K, V>,
    AbstractHeapTrackingConcurrentHash.Wrapper<Entry<K, V>> {
        private final K key;
        private final V value;
        private final Entry<K, V> next;

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
            this.next = null;
        }

        private Entry(K key, V value, Entry<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Entry<K, V> getNext() {
            return this.next;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k2 = e.getKey();
            if (!Objects.equals(this.key, k2)) {
                return false;
            }
            Object v2 = e.getValue();
            return Objects.equals(this.value, v2);
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + String.valueOf(this.value);
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return HeapTrackingConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return HeapTrackingConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return HeapTrackingConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            HeapTrackingConcurrentHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean removeAll(Collection<?> col) {
            Objects.requireNonNull(col);
            boolean removed = false;
            ValueIterator itr = new ValueIterator();
            while (itr.hasNext()) {
                if (!col.contains(itr.next())) continue;
                removed |= itr.removeByKeyValue();
            }
            return removed;
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            Objects.requireNonNull(filter);
            boolean removed = false;
            ValueIterator itr = new ValueIterator();
            while (itr.hasNext()) {
                if (!filter.test(itr.next())) continue;
                removed |= itr.removeByKeyValue();
            }
            return removed;
        }

        @Override
        public int size() {
            return HeapTrackingConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return HeapTrackingConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            HeapTrackingConcurrentHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean removeAll(Collection<?> col) {
            Objects.requireNonNull(col);
            boolean removed = false;
            if (this.size() > col.size()) {
                for (Object o : col) {
                    removed |= this.remove(o);
                }
            } else {
                EntryIterator itr = new EntryIterator();
                while (itr.hasNext()) {
                    if (!col.contains(itr.next())) continue;
                    removed |= itr.removeByKeyValue();
                }
            }
            return removed;
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            Objects.requireNonNull(filter);
            boolean removed = false;
            EntryIterator itr = new EntryIterator();
            while (itr.hasNext()) {
                if (!filter.test((Map.Entry)itr.next())) continue;
                removed |= itr.removeByKeyValue();
            }
            return removed;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = HeapTrackingConcurrentHashMap.this.getEntry(e.getKey());
            return e.equals(candidate);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return HeapTrackingConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return HeapTrackingConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            HeapTrackingConcurrentHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashMapIterator<Map.Entry<K, V>>
    implements Iterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        @Override
        public void remove() {
            this.removeByKeyValue();
        }
    }

    private final class KeyIterator
    extends HashMapIterator<K>
    implements Iterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }

        @Override
        public void remove() {
            this.removeByKey();
        }
    }

    private final class ValueIterator
    extends HashMapIterator<V>
    implements Iterator<V> {
        private ValueIterator() {
        }

        @Override
        public void remove() {
            this.removeByKeyValue();
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashMapIterator<E>
    extends AbstractHeapTrackingConcurrentHash.HashIterator<Entry<K, V>> {
        private HashMapIterator() {
        }

        final Entry<K, V> nextEntry() {
            Entry e = (Entry)this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.getNext();
            if (this.next == null) {
                this.findNext();
            }
            this.current = e;
            return e;
        }

        protected void removeByKey() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object key = ((Entry)this.current).key;
            this.current = null;
            HeapTrackingConcurrentHashMap.this.remove(key);
        }

        protected boolean removeByKeyValue() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object key = ((Entry)this.current).key;
            Object val = ((Entry)this.current).value;
            this.current = null;
            return HeapTrackingConcurrentHashMap.this.remove(key, val);
        }
    }
}

