/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.neo4j.collection.trackable.AbstractHeapTrackingConcurrentHash;
import org.neo4j.collection.trackable.HeapTrackingConcurrentHashCollection;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class HeapTrackingConcurrentHashSet<E>
extends HeapTrackingConcurrentHashCollection<E>
implements Set<E>,
AutoCloseable {
    private static final long SHALLOW_SIZE_THIS = HeapEstimator.shallowSizeOfInstance(HeapTrackingConcurrentHashSet.class);

    public static <E> HeapTrackingConcurrentHashSet<E> newSet(MemoryTracker memoryTracker) {
        return HeapTrackingConcurrentHashSet.newSet(memoryTracker, 16);
    }

    public static <E> HeapTrackingConcurrentHashSet<E> newSet(MemoryTracker memoryTracker, int size) {
        memoryTracker.allocateHeap(SHALLOW_SIZE_THIS);
        return new HeapTrackingConcurrentHashSet<E>(memoryTracker, size);
    }

    private HeapTrackingConcurrentHashSet(MemoryTracker memoryTracker, int initialCapacity) {
        super(memoryTracker, initialCapacity);
    }

    @Override
    public boolean add(E value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(value);
        int index = HeapTrackingConcurrentHashSet.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            HeapTrackingConcurrentHashCollection.Node<E> newNode = new HeapTrackingConcurrentHashCollection.Node<E>(value, null);
            this.addToSize(1);
            if (currentArray.compareAndSet(index, null, newNode)) {
                return true;
            }
            this.addToSize(-1);
        }
        return this.slowAdd(value, hash, currentArray);
    }

    private boolean slowAdd(E value, int hash, AtomicReferenceArray<Object> currentArray) {
        int length;
        Object o;
        while (true) {
            int index;
            if ((o = currentArray.get(index = HeapTrackingConcurrentHashSet.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (HeapTrackingConcurrentHashCollection.Node)o; e != null; e = ((HeapTrackingConcurrentHashCollection.Node)e).getNext()) {
                Object candidate = ((HeapTrackingConcurrentHashCollection.Node)e).value;
                if (!candidate.equals(value)) continue;
                return false;
            }
            HeapTrackingConcurrentHashCollection.Node<E> newNode = new HeapTrackingConcurrentHashCollection.Node<E>(value, (HeapTrackingConcurrentHashCollection.Node)o);
            if (currentArray.compareAndSet(index, o, newNode)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return true;
    }

    @Override
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList(this.size());
        for (Object e : this) {
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList arrayList = new ArrayList(this.size());
        for (Object e : this) {
            arrayList.add(e);
        }
        return arrayList.toArray(a);
    }

    @Override
    public boolean contains(Object value) {
        int length;
        int index;
        Object o;
        int hash = this.hash(value);
        AtomicReferenceArray<Object> currentArray = this.table;
        while ((o = currentArray.get(index = HeapTrackingConcurrentHashSet.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Object e = (HeapTrackingConcurrentHashCollection.Node)o; e != null; e = ((HeapTrackingConcurrentHashCollection.Node)e).getNext()) {
            Object candidate = ((HeapTrackingConcurrentHashCollection.Node)e).value;
            if (!candidate.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer;
        AtomicReferenceArray<Object> currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = currentArray.get(i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                if (!currentArray.compareAndSet(i, o, null)) continue;
                int removedEntries = 0;
                for (Object e = (HeapTrackingConcurrentHashCollection.Node)o; e != null; e = ((HeapTrackingConcurrentHashCollection.Node)e).getNext()) {
                    ++removedEntries;
                }
                this.addToSize(-removedEntries);
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
    }

    @Override
    public boolean remove(Object value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(value);
        int index = HeapTrackingConcurrentHashSet.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowRemove(value, hash, currentArray);
        }
        for (Object e = (HeapTrackingConcurrentHashCollection.Node)o; e != null; e = ((HeapTrackingConcurrentHashCollection.Node)e).getNext()) {
            Object candidate = ((HeapTrackingConcurrentHashCollection.Node)e).value;
            if (!candidate.equals(value)) continue;
            HeapTrackingConcurrentHashCollection.Node<E> replacement = this.createReplacementChainForRemoval((HeapTrackingConcurrentHashCollection.Node)o, (HeapTrackingConcurrentHashCollection.Node<E>)e);
            if (currentArray.compareAndSet(index, o, replacement)) {
                this.addToSize(-1);
                return true;
            }
            return this.slowRemove(value, hash, currentArray);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        for (Object e : this) {
            if (c.contains(e) || !this.remove(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            if (!this.remove(e)) continue;
            modified = true;
        }
        return modified;
    }

    /*
     * Unable to fully structure code
     */
    private boolean slowRemove(Object value, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            if ((o = currentArray.get(index = HeapTrackingConcurrentHashSet.indexFor(hash, length = currentArray.length()))) == HeapTrackingConcurrentHashSet.RESIZED || o == HeapTrackingConcurrentHashSet.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (HeapTrackingConcurrentHashCollection.Node)o; e != null; e = e.getNext()) {
                candidate = e.value;
                if (!candidate.equals(value)) continue;
                replacement = this.createReplacementChainForRemoval((HeapTrackingConcurrentHashCollection.Node)o, (HeapTrackingConcurrentHashCollection.Node<E>)e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return true;
            }
            break;
        }
        return false;
    }

    private HeapTrackingConcurrentHashCollection.Node<E> createReplacementChainForRemoval(HeapTrackingConcurrentHashCollection.Node<E> original, HeapTrackingConcurrentHashCollection.Node<E> toRemove) {
        if (original == toRemove) {
            return original.getNext();
        }
        HeapTrackingConcurrentHashCollection.Node replacement = null;
        for (Object e = original; e != null; e = ((HeapTrackingConcurrentHashCollection.Node)e).getNext()) {
            if (e == toRemove) continue;
            replacement = new HeapTrackingConcurrentHashCollection.Node(((HeapTrackingConcurrentHashCollection.Node)e).value, replacement);
        }
        return replacement;
    }

    @Override
    public int hashCode() {
        int h = 0;
        AtomicReferenceArray currentArray = this.table;
        for (int i = 0; i < currentArray.length() - 1; ++i) {
            Object o = currentArray.get(i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't compute hashcode while resizing!");
            }
            for (Object e = (HeapTrackingConcurrentHashCollection.Node)o; e != null; e = ((HeapTrackingConcurrentHashCollection.Node)e).getNext()) {
                Object value = ((HeapTrackingConcurrentHashCollection.Node)e).value;
                h += value == null ? 0 : value.hashCode();
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        if (s.size() != this.size()) {
            return false;
        }
        for (Object e : this) {
            if (s.contains(e)) continue;
            return false;
        }
        return true;
    }
}

