/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.SchedulerThreadFactory;

interface ExecutorServiceFactory {
    public ExecutorService build(Group var1, SchedulerThreadFactory var2);

    public ExecutorService build(Group var1, SchedulerThreadFactory var2, int var3);

    public static ExecutorServiceFactory unschedulable() {
        return new ExecutorServiceFactory(){

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory) {
                throw this.newUnschedulableException(group);
            }

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory, int threadCount) {
                throw this.newUnschedulableException(group);
            }

            private IllegalArgumentException newUnschedulableException(Group group) {
                return new IllegalArgumentException("Tasks cannot be scheduled directly to the " + group.groupName() + " group.");
            }
        };
    }

    public static ExecutorServiceFactory singleThread() {
        return new ExecutorServiceFactory(){

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory) {
                return Executors.newSingleThreadExecutor(factory);
            }

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory, int threadCount) {
                return this.build(group, factory);
            }
        };
    }

    public static ExecutorServiceFactory cached() {
        return new ExecutorServiceFactory(){

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory) {
                return Executors.newCachedThreadPool(factory);
            }

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory, int threadCount) {
                return Executors.newFixedThreadPool(threadCount, factory);
            }
        };
    }

    public static ExecutorServiceFactory workStealing() {
        return new ExecutorServiceFactory(){

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory) {
                return new ForkJoinPool(Runtime.getRuntime().availableProcessors(), factory, null, false);
            }

            @Override
            public ExecutorService build(Group group, SchedulerThreadFactory factory, int threadCount) {
                return new ForkJoinPool(threadCount, factory, null, false);
            }
        };
    }
}

