/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.neo4j.function.Predicates;

@Deprecated
public class Exceptions {
    public static final Thread.UncaughtExceptionHandler SILENT_UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> {};
    private static final String UNEXPECTED_MESSAGE = "Unexpected Exception";
    private static final Field THROWABLE_MESSAGE_FIELD;

    private Exceptions() {
        throw new AssertionError((Object)"No instances");
    }

    public static void throwIfUnchecked(Throwable exception) {
        Objects.requireNonNull(exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
    }

    public static <T extends Throwable> void throwIfInstanceOf(Throwable exception, Class<T> clazz) throws T {
        Objects.requireNonNull(exception);
        if (clazz.isInstance(exception)) {
            throw (Throwable)clazz.cast(exception);
        }
    }

    @Deprecated
    public static <T extends Throwable> T withCause(T exception, Throwable cause) {
        try {
            exception.initCause(cause);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception;
    }

    @Deprecated
    public static <T extends Throwable> T withSuppressed(T exception, Throwable ... suppressed) {
        if (suppressed != null) {
            for (Throwable s : suppressed) {
                exception.addSuppressed(s);
            }
        }
        return exception;
    }

    @Deprecated
    public static RuntimeException launderedException(Throwable exception) {
        return Exceptions.launderedException(RuntimeException.class, UNEXPECTED_MESSAGE, exception);
    }

    @Deprecated
    public static RuntimeException launderedException(String messageForUnexpected, Throwable exception) {
        return Exceptions.launderedException(RuntimeException.class, messageForUnexpected, exception);
    }

    @Deprecated
    public static <T extends Throwable> T launderedException(Class<T> type, Throwable exception) {
        return Exceptions.launderedException(type, UNEXPECTED_MESSAGE, exception);
    }

    @Deprecated
    public static <T extends Throwable> T launderedException(Class<T> type, String messageForUnexpected, Throwable exception) {
        if (type.isInstance(exception)) {
            return (T)((Throwable)type.cast(exception));
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof InvocationTargetException) {
            return Exceptions.launderedException(type, messageForUnexpected, ((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(messageForUnexpected, exception);
    }

    public static Throwable peel(Throwable exception, Predicate<Throwable> toPeel) {
        while (exception != null && toPeel.test(exception)) {
            exception = exception.getCause();
        }
        return exception;
    }

    public static Throwable rootCause(Throwable caughtException) {
        if (null == caughtException) {
            throw new IllegalArgumentException("Cannot obtain rootCause from (null)");
        }
        Throwable root = caughtException;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    public static Optional<Throwable> findCauseOrSuppressed(Throwable e, Predicate<Throwable> predicate) {
        Optional<Throwable> cause;
        if (e == null) {
            return Optional.empty();
        }
        if (predicate.test(e)) {
            return Optional.of(e);
        }
        if (e.getCause() != null && e.getCause() != e && (cause = Exceptions.findCauseOrSuppressed(e.getCause(), predicate)).isPresent()) {
            return cause;
        }
        if (e.getSuppressed() != null) {
            for (Throwable suppressed : e.getSuppressed()) {
                Optional<Throwable> cause2;
                if (suppressed == e || !(cause2 = Exceptions.findCauseOrSuppressed(suppressed, predicate)).isPresent()) continue;
                return cause2;
            }
        }
        return Optional.empty();
    }

    public static String stringify(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String stringify(Thread thread, StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder("\"" + thread.getName() + "\"" + (thread.isDaemon() ? " daemon" : "") + " prio=" + thread.getPriority() + " tid=" + thread.getId() + " " + thread.getState().name().toLowerCase() + "\n");
        builder.append("   ").append(Thread.State.class.getName()).append(": ").append(thread.getState().name().toUpperCase()).append("\n");
        for (StackTraceElement element : elements) {
            builder.append("      at ").append(element.getClassName()).append(".").append(element.getMethodName());
            if (element.isNativeMethod()) {
                builder.append("(Native method)");
            } else if (element.getFileName() == null) {
                builder.append("(Unknown source)");
            } else {
                builder.append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static boolean contains(Throwable cause, String containsMessage, Class ... anyOfTheseClasses) {
        Predicate anyOfClasses = Predicates.instanceOfAny(anyOfTheseClasses);
        return Exceptions.contains(cause, (Throwable item) -> item.getMessage() != null && item.getMessage().contains(containsMessage) && anyOfClasses.test(item));
    }

    public static boolean contains(Throwable cause, Class ... anyOfTheseClasses) {
        return Exceptions.contains(cause, Predicates.instanceOfAny(anyOfTheseClasses));
    }

    public static boolean contains(Throwable cause, Predicate<Throwable> toLookFor) {
        while (cause != null) {
            if (toLookFor.test(cause)) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    @Deprecated
    public static <E extends Throwable> E combine(E first, E second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        Object current = first;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        current.initCause(second);
        return first;
    }

    public static void setMessage(Throwable cause, String message) {
        try {
            THROWABLE_MESSAGE_FIELD.set(cause, message);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Throwable> T withMessage(T cause, String message) {
        Exceptions.setMessage(cause, message);
        return cause;
    }

    public static <T extends Throwable> T chain(T initial, T current) {
        if (initial == null) {
            return current;
        }
        if (current != null) {
            initial.addSuppressed(current);
        }
        return initial;
    }

    static {
        try {
            THROWABLE_MESSAGE_FIELD = Throwable.class.getDeclaredField("detailMessage");
            THROWABLE_MESSAGE_FIELD.setAccessible(true);
        }
        catch (Exception e2) {
            throw new LinkageError("Could not get Throwable message field", e2);
        }
    }
}

