/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.neo4j.time.Stopwatch;

public class SystemNanoClock
extends Clock {
    static final SystemNanoClock INSTANCE = new SystemNanoClock();

    protected SystemNanoClock() {
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return Clock.system(zone);
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.millis());
    }

    @Override
    public long millis() {
        return System.currentTimeMillis();
    }

    public long nanos() {
        return System.nanoTime();
    }

    public Stopwatch startStopWatch() {
        return new Stopwatch(System::nanoTime);
    }
}

