/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cursor;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface RawCursor<T, EXCEPTION extends Exception>
extends Supplier<T>,
AutoCloseable {
    public boolean next() throws EXCEPTION;

    @Override
    public void close() throws EXCEPTION;

    default public void forAll(Consumer<T> consumer) throws EXCEPTION {
        try {
            while (this.next()) {
                consumer.accept(this.get());
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R foldl(BiFunction<T, R, R> fold, R zero) throws EXCEPTION {
        R last = zero;
        try {
            while (this.next()) {
                Object t = this.get();
                last = fold.apply(t, last);
            }
        }
        finally {
            this.close();
        }
        return last;
    }
}

