/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.SchedulerThreadFactory;

interface ExecutorServiceFactory {
    public ExecutorService build(Group var1, SchedulerThreadFactory var2, int var3);

    public static ExecutorServiceFactory unschedulable() {
        return (group, factory, threadCount) -> new ThrowingExecutorService(group);
    }

    public static ExecutorServiceFactory singleThread() {
        return (group, factory, threadCount) -> Executors.newSingleThreadExecutor(factory);
    }

    public static ExecutorServiceFactory callingThread() {
        return (group, factory, threadCount) -> new CallingThreadExecutorService(group);
    }

    public static ExecutorServiceFactory cached() {
        return (group, factory, threadCount) -> {
            if (threadCount == 0) {
                return Executors.newCachedThreadPool(factory);
            }
            return Executors.newFixedThreadPool(threadCount, factory);
        };
    }

    public static ExecutorServiceFactory workStealing() {
        return (group, factory, threadCount) -> {
            if (threadCount == 0) {
                threadCount = Runtime.getRuntime().availableProcessors();
            }
            return new ForkJoinPool(threadCount, factory, null, false);
        };
    }

    public static ExecutorServiceFactory cachedWithDiscard() {
        return (group, factory, threadCount) -> {
            if (threadCount == 0) {
                return new DiscardingExecutorService(group);
            }
            ThreadPoolExecutor.DiscardPolicy policy = new ThreadPoolExecutor.DiscardPolicy();
            return new ThreadPoolExecutor(0, threadCount, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory, policy);
        };
    }

    public static class DiscardingExecutorService
    extends ExecutorServiceAdapter {
        private DiscardingExecutorService(Group group) {
            super(group);
        }

        @Override
        public void execute(Runnable runnable) {
            if (runnable instanceof FutureTask) {
                ((FutureTask)runnable).cancel(false);
            }
        }
    }

    public static class CallingThreadExecutorService
    extends ExecutorServiceAdapter {
        private CallingThreadExecutorService(Group group) {
            super(group);
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }

    public static class ThrowingExecutorService
    extends ExecutorServiceAdapter {
        private ThrowingExecutorService(Group group) {
            super(group);
        }

        @Override
        public void execute(Runnable runnable) {
            throw new RejectedExecutionException("Tasks cannot be scheduled directly to the " + this.group.groupName() + " group.");
        }
    }

    public static abstract class ExecutorServiceAdapter
    extends AbstractExecutorService {
        protected final Group group;
        private volatile boolean shutdown;

        private ExecutorServiceAdapter(Group group) {
            this.group = group;
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.shutdown;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }
}

