/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.helpers.Format;
import org.neo4j.time.SystemNanoClock;

public abstract class Indicator {
    public static final Indicator NONE = new Indicator(1){

        @Override
        protected void progress(int from, int to) {
        }
    };
    private final int reportResolution;

    public Indicator(int reportResolution) {
        this.reportResolution = reportResolution;
    }

    protected abstract void progress(int var1, int var2);

    public void mark(char mark) {
    }

    int reportResolution() {
        return this.reportResolution;
    }

    public void startProcess(long totalCount) {
    }

    public void failure(Throwable cause) {
    }

    static class Textual
    extends Indicator {
        static final int DEFAULT_DOTS_PER_GROUP = 20;
        static final int DEFAULT_GROUPS_PER_LINE = 1;
        static final int DEFAULT_NUM_LINES = 10;
        static final char DEFAULT_DELTA_CHARACTER = '\u2206';
        private final String process;
        private final PrintWriter out;
        private final boolean deltaTimes;
        private final SystemNanoClock clock;
        private final char deltaCharacter;
        private final int dotsPerGroup;
        private final int groupsPerLine;
        private final int dotsPerLine;
        private long lastReportTime;
        private long startTime;
        private Character mark;

        Textual(String process, PrintWriter out, boolean deltaTimes, SystemNanoClock clock, char deltaCharacter, int dotsPerGroup, int groupsPerLine, int numLines) {
            super(dotsPerGroup * groupsPerLine * numLines);
            this.process = process;
            this.out = out;
            this.deltaTimes = deltaTimes;
            this.clock = clock;
            this.deltaCharacter = deltaCharacter;
            this.dotsPerGroup = dotsPerGroup;
            this.groupsPerLine = groupsPerLine;
            this.dotsPerLine = dotsPerGroup * groupsPerLine;
        }

        @Override
        public void startProcess(long totalCount) {
            this.out.println(this.process);
            this.out.flush();
            this.startTime = this.lastReportTime = this.clock.nanos();
        }

        @Override
        protected void progress(int from, int to) {
            int i = from;
            while (i < to) {
                this.printProgress(++i);
            }
            this.out.flush();
        }

        @Override
        public void mark(char mark) {
            this.mark = Character.valueOf(mark);
        }

        @Override
        public void failure(Throwable cause) {
            cause.printStackTrace(this.out);
        }

        private void printProgress(int progress) {
            int lineBasedProgress;
            if (this.groupsPerLine > 1 && (lineBasedProgress = (progress - 1) % this.dotsPerLine) > 0 && lineBasedProgress % this.dotsPerGroup == 0) {
                this.out.print(' ');
            }
            this.out.print(this.progressCharacter());
            if (progress % this.dotsPerLine == 0) {
                this.out.printf(" %3d%%", progress * 100 / this.reportResolution());
                long currentTime = this.clock.nanos();
                if (this.deltaTimes) {
                    long time = currentTime - this.lastReportTime;
                    long totalTime = currentTime - this.startTime;
                    this.out.printf(" %c%s [%s]", Character.valueOf(this.deltaCharacter), Format.duration(TimeUnit.NANOSECONDS.toMillis(time)), Format.duration(TimeUnit.NANOSECONDS.toMillis(totalTime)));
                }
                this.out.printf("%n", new Object[0]);
                this.lastReportTime = currentTime;
            }
        }

        private char progressCharacter() {
            if (this.mark != null) {
                try {
                    char c = this.mark.charValue();
                    return c;
                }
                finally {
                    this.mark = null;
                }
            }
            return '.';
        }
    }
}

