/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.identity;

import java.util.Optional;
import java.util.UUID;
import org.neo4j.util.Id;

public final class ServerId
extends Id
implements Comparable<ServerId> {
    private static final int UUID_LEN = 36;

    public static Optional<ServerId> from(String uuid) {
        if (uuid != null && uuid.length() == 36) {
            try {
                return Optional.of(new ServerId(UUID.fromString(uuid)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public ServerId(UUID uuid) {
        super(uuid);
    }

    @Override
    public String toString() {
        return "ServerId{" + this.shortName() + "}";
    }

    @Override
    public int compareTo(ServerId other) {
        return this.uuid().compareTo(other.uuid());
    }
}

