/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class RebindableDualScopedMemoryTracker
extends DefaultScopedMemoryTracker {
    private MemoryTracker innerDelegate;
    private long unreleasedInnerScopeNative;
    private long unreleasedInnerScopeHeap;

    public RebindableDualScopedMemoryTracker(MemoryTracker outerDelegate) {
        super(outerDelegate);
    }

    public void setInnerDelegate(MemoryTracker innerDelegate) {
        MemoryTracker scopedInner = innerDelegate.getScopedMemoryTracker();
        scopedInner.allocateNative(this.unreleasedInnerScopeNative);
        scopedInner.allocateHeap(this.unreleasedInnerScopeHeap);
        this.innerDelegate = scopedInner;
    }

    @Override
    public long usedNativeMemory() {
        long outer = super.usedNativeMemory();
        return this.innerDelegate != null ? this.innerDelegate.usedNativeMemory() + outer : outer;
    }

    @Override
    public long estimatedHeapMemory() {
        long outer = super.estimatedHeapMemory();
        return this.innerDelegate != null ? this.innerDelegate.estimatedHeapMemory() + outer : outer;
    }

    @Override
    public void allocateNative(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.allocateNative(bytes);
        } else {
            super.allocateNative(bytes);
        }
    }

    @Override
    public void releaseNative(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.releaseNative(bytes);
        } else {
            super.releaseNative(bytes);
        }
    }

    @Override
    public void allocateHeap(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.allocateHeap(bytes);
        } else {
            super.allocateHeap(bytes);
        }
    }

    @Override
    public void releaseHeap(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.releaseHeap(bytes);
        } else {
            super.releaseHeap(bytes);
        }
    }

    @Override
    public long heapHighWaterMark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.innerDelegate.reset();
        this.unreleasedInnerScopeNative = 0L;
        this.unreleasedInnerScopeHeap = 0L;
        super.reset();
    }

    @Override
    public void close() {
        if (this.innerDelegate != null) {
            this.closeInner();
        }
        assert (this.unreleasedInnerScopeNative == 0L) : "Unreleased inner native memory";
        this.unreleasedInnerScopeNative = 0L;
        assert (this.unreleasedInnerScopeHeap == 0L) : "Unreleased inner heap memory";
        this.unreleasedInnerScopeHeap = 0L;
        super.close();
    }

    public void closeInner() {
        if (this.innerDelegate != null) {
            this.unreleasedInnerScopeNative = this.innerDelegate.usedNativeMemory();
            this.unreleasedInnerScopeHeap = this.innerDelegate.estimatedHeapMemory();
            this.innerDelegate.close();
            this.innerDelegate = null;
        }
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new DefaultScopedMemoryTracker(this, this.getHeapEstimatorCache());
    }

    @VisibleForTesting
    protected long unreleasedInnerScopeNative() {
        return this.unreleasedInnerScopeNative;
    }

    @VisibleForTesting
    protected long unreleasedInnerScopeHeap() {
        return this.unreleasedInnerScopeHeap;
    }
}

