/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import com.sun.management.ThreadMXBean;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.util.Preconditions;

final class SunManagementHeapAllocation
extends HeapAllocation {
    private final ThreadMXBean threadMXBean;

    static HeapAllocation load(java.lang.management.ThreadMXBean bean) {
        Preconditions.checkArgument(bean instanceof ThreadMXBean, "The ThreadMXBean must be an instance of '" + ThreadMXBean.class.getName() + "'.");
        ThreadMXBean threadMXBean = (ThreadMXBean)bean;
        Preconditions.checkState(threadMXBean.isThreadAllocatedMemorySupported(), "Thread allocations not supported.");
        return new SunManagementHeapAllocation(threadMXBean);
    }

    private SunManagementHeapAllocation(ThreadMXBean threadMXBean) {
        this.threadMXBean = threadMXBean;
        if (!threadMXBean.isThreadAllocatedMemoryEnabled()) {
            threadMXBean.setThreadAllocatedMemoryEnabled(true);
        }
    }

    @Override
    public long allocatedBytes(long threadId) {
        return this.threadMXBean.getThreadAllocatedBytes(threadId);
    }
}

