/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.util.Preconditions;

public class ToolingMemoryCalculations {
    public static final Monitor NOTIFY_SYS_ERR = amountOfMemoryUsedInstead -> System.err.println("WARNING: amount of free memory couldn't be detected so defaults to " + ByteUnit.bytesToString((long)amountOfMemoryUsedInstead) + ". For optimal performance instead explicitly specify amount of memory using --max-off-heap-memory");
    public static final Monitor NO_MONITOR = amountOfMemoryUsedInstead -> {};
    private final Monitor monitor;

    public ToolingMemoryCalculations(Monitor monitor) {
        this.monitor = monitor;
    }

    public long calculateMaxAvailableOffHeapMemoryFromPercent(int percent) {
        return this.calculateMaxAvailableOffHeapMemoryFromPercent(percent, OsBeanUtil.getFreeMemory(), Runtime.getRuntime().maxMemory());
    }

    public long calculateMaxAvailableOffHeapMemoryFromPercent(int percent, long freePhysicalMemory, long maxRuntimeMemory) {
        Preconditions.requireBetween((int)percent, (int)1, (int)100);
        if (freePhysicalMemory == -1L) {
            long defaultMemory = ByteUnit.gibiBytes((long)2L);
            this.monitor.unableToDetectMachineMemory(defaultMemory);
            return defaultMemory;
        }
        double factor = (double)percent / 100.0;
        long jvmMaxMemory = Math.min(maxRuntimeMemory, freePhysicalMemory / 2L);
        long availableMemory = freePhysicalMemory - jvmMaxMemory;
        return Math.round((double)availableMemory * factor);
    }

    public long calculateMaxAvailableOffHeapMemory(String value) {
        if ((value = value.trim()).endsWith("%")) {
            int percent = Integer.parseInt(value.substring(0, value.length() - 1));
            return this.calculateMaxAvailableOffHeapMemoryFromPercent(percent);
        }
        return SettingValueParsers.parseLongWithUnit(value);
    }

    public static interface Monitor {
        public void unableToDetectMachineMemory(long var1);
    }
}

