/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.BufferingLog;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.configuration.SettingObserver;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.ProcessUtils;
import org.neo4j.logging.InternalLog;
import org.neo4j.service.Services;
import org.neo4j.util.Preconditions;

public class Config
implements Configuration {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";
    public static final String DEFAULT_CONFIG_DIR_NAME = "conf";
    private static final String STRICT_FAILURE_MESSAGE = String.format(" Cleanup the config or disable '%s' to continue.", GraphDatabaseSettings.strict_config_validation.name());
    private static final String LEGACY_4_X_DBMS_JVM_ADDITIONAL = "dbms.jvm.additional";
    public static final String APOC_NAMESPACE = "apoc.";
    private static final List<String> SUPPORTED_NAMESPACES = List.of("dbms.", "db.", "browser.", "server.", "internal.", "client.", "initial.", "fabric.", "gds.", "apoc.");
    private static final Collection<Class<SettingsDeclaration>> DEFAULT_SETTING_CLASSES = Services.loadAll(SettingsDeclaration.class).stream().map(c -> c.getClass()).toList();
    private static final Collection<Class<GroupSetting>> DEFAULT_GROUP_SETTING_CLASSES = Services.loadAll(GroupSetting.class).stream().map(c -> c.getClass()).toList();
    private static final Collection<SettingMigrator> DEFAULT_SETTING_MIGRATORS = Services.loadAll(SettingMigrator.class);
    protected final Map<String, Entry<?>> settings = new HashMap();
    private final Map<Class<? extends GroupSetting>, Map<String, GroupSetting>> allGroupInstances = new HashMap<Class<? extends GroupSetting>, Map<String, GroupSetting>>();
    private InternalLog log;
    private final boolean expandCommands;
    private final Configuration validationConfig = new ValidationConfig();
    private Duration commandEvaluationTimeout = (Duration)GraphDatabaseInternalSettings.config_command_evaluation_timeout.defaultValue();

    public static Config defaults() {
        return Config.defaults(Map.of());
    }

    public static <T> Config defaults(Setting<T> setting, T value) {
        return Config.defaults(Map.of(setting, value));
    }

    public static Config defaults(Map<Setting<?>, Object> settingValues) {
        return Config.newBuilder().set(settingValues).build();
    }

    public static Builder newBuilder() {
        Builder builder = new Builder();
        DEFAULT_SETTING_CLASSES.forEach(builder::addSettingsClass);
        DEFAULT_GROUP_SETTING_CLASSES.forEach(builder::addGroupSettingClass);
        DEFAULT_SETTING_MIGRATORS.forEach(builder::addMigrator);
        return builder;
    }

    public static Builder newBuilder(ClassLoader classLoader) {
        Builder builder = new Builder();
        Services.loadAll((ClassLoader)classLoader, SettingsDeclaration.class).forEach(decl -> builder.addSettingsClass(decl.getClass()));
        Services.loadAll((ClassLoader)classLoader, GroupSetting.class).forEach(decl -> builder.addGroupSettingClass(decl.getClass()));
        Services.loadAll((ClassLoader)classLoader, SettingMigrator.class).forEach(builder::addMigrator);
        return builder;
    }

    static Builder emptyBuilder() {
        return new Builder();
    }

    protected Config() {
        this.expandCommands = false;
    }

    private Config(Collection<Class<? extends SettingsDeclaration>> settingsClasses, Collection<Class<? extends GroupSetting>> groupSettingClasses, Collection<SettingMigrator> settingMigrators, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Map<String, Object> overriddenDefaultObjects, Config fromConfig, InternalLog log, boolean expandCommands, String strictDuplicateDeclarationWarningMessage) {
        this.log = log;
        this.expandCommands = expandCommands;
        if (expandCommands) {
            log.info("Command expansion is explicitly enabled for configuration");
        }
        HashMap<String, String> overriddenDefaultStrings = new HashMap<String, String>();
        try {
            settingMigrators.forEach(migrator -> migrator.migrate(settingValueStrings, overriddenDefaultStrings, log));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error while migrating settings, please see the exception cause", e);
        }
        Map<String, SettingImpl<?>> definedSettings = Config.getDefinedSettings(settingsClasses);
        Map<String, Class<? extends GroupSetting>> definedGroups = Config.getDefinedGroups(groupSettingClasses);
        HashSet<String> keys = new HashSet<String>(definedSettings.keySet());
        keys.addAll(settingValueStrings.keySet());
        keys.addAll(settingValueObjects.keySet());
        ArrayList newSettings = new ArrayList();
        if (fromConfig != null) {
            fromConfig.allGroupInstances.forEach((cls, fromGroupMap) -> {
                Map groupMap = this.allGroupInstances.computeIfAbsent((Class<? extends GroupSetting>)cls, k -> new HashMap());
                groupMap.putAll(fromGroupMap);
            });
            for (Map.Entry<String, Entry<?>> entry : fromConfig.settings.entrySet()) {
                newSettings.add(entry.getValue().setting);
                keys.remove(entry.getKey());
            }
        }
        boolean strict = (Boolean)GraphDatabaseSettings.strict_config_validation.defaultValue();
        if (keys.remove(GraphDatabaseSettings.strict_config_validation.name())) {
            this.evaluateSetting(GraphDatabaseSettings.strict_config_validation, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects, false);
            strict = this.get(GraphDatabaseSettings.strict_config_validation);
        }
        boolean allowDuplicates = (Boolean)GraphDatabaseInternalSettings.strict_config_validation_allow_duplicates.defaultValue();
        if (strict && keys.remove(GraphDatabaseInternalSettings.strict_config_validation_allow_duplicates.name())) {
            this.evaluateSetting(GraphDatabaseInternalSettings.strict_config_validation_allow_duplicates, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects, strict);
            allowDuplicates = this.get(GraphDatabaseInternalSettings.strict_config_validation_allow_duplicates);
        }
        if (strict && !allowDuplicates && StringUtils.isNotEmpty((CharSequence)strictDuplicateDeclarationWarningMessage)) {
            throw new IllegalArgumentException(strictDuplicateDeclarationWarningMessage);
        }
        if (keys.remove(GraphDatabaseInternalSettings.config_command_evaluation_timeout.name())) {
            this.evaluateSetting(GraphDatabaseInternalSettings.config_command_evaluation_timeout, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects, strict);
            this.commandEvaluationTimeout = this.get(GraphDatabaseInternalSettings.config_command_evaluation_timeout);
        }
        newSettings.addAll(this.getActiveSettings(keys, definedGroups, definedSettings, strict));
        this.evaluateSettingValues(newSettings, settingValueStrings, settingValueObjects, overriddenDefaultStrings, overriddenDefaultObjects, fromConfig, strict);
    }

    private void evaluateSettingValues(Collection<SettingImpl<?>> settingsToEvaluate, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Map<String, String> overriddenDefaultStrings, Map<String, Object> overriddenDefaultObjects, Config fromConfig, boolean strict) {
        ArrayDeque newSettings = new ArrayDeque(settingsToEvaluate);
        while (!newSettings.isEmpty()) {
            SettingImpl setting;
            boolean modified = false;
            SettingImpl last = (SettingImpl)newSettings.peekLast();
            HashMap<SettingImpl, SettingImpl<Object>> dependencies = new HashMap<SettingImpl, SettingImpl<Object>>();
            do {
                setting = Objects.requireNonNull((SettingImpl)newSettings.pollFirst());
                boolean retry = false;
                if (setting.dependency() != null && !this.settings.containsKey(setting.dependency().name())) {
                    dependencies.put(setting, setting.dependency());
                    retry = true;
                } else {
                    try {
                        this.evaluateSetting(setting, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects, strict);
                        modified = true;
                    }
                    catch (AccessDuringEvaluationException e) {
                        dependencies.put(setting, (SettingImpl<Object>)e.getAttemptedAccess());
                        retry = true;
                    }
                }
                if (!retry) continue;
                newSettings.addLast(setting);
            } while (setting != last);
            if (modified || newSettings.isEmpty()) continue;
            String unsolvable = newSettings.stream().map(s -> String.format("'%s'->'%s'", s.name(), ((Setting)dependencies.get(s)).name())).collect(Collectors.joining(",\n", "[", "]"));
            throw new IllegalArgumentException(String.format("Can not resolve setting dependencies. %s depend on settings not present in config, or are in a circular dependency ", unsolvable));
        }
    }

    private Collection<SettingImpl<?>> getActiveSettings(Set<String> settingNames, Map<String, Class<? extends GroupSetting>> definedGroups, Map<String, SettingImpl<?>> declaredSettings, boolean strict) {
        ArrayList newSettings = new ArrayList();
        for (String key : settingNames) {
            GroupSetting group;
            String id;
            SettingImpl<?> setting = declaredSettings.get(key);
            if (setting != null) {
                newSettings.add(setting);
                continue;
            }
            Optional<Map.Entry> groupEntryOpt = definedGroups.entrySet().stream().filter(e -> key.startsWith((String)e.getKey() + ".")).findAny();
            if (groupEntryOpt.isEmpty()) {
                String msg = this.createUnrecognizedSettingMessage(key);
                if (strict) {
                    throw new IllegalArgumentException(msg + STRICT_FAILURE_MESSAGE);
                }
                this.log.warn(msg);
                continue;
            }
            Map.Entry groupEntry = groupEntryOpt.get();
            String prefix = (String)groupEntry.getKey();
            String keyWithoutPrefix = key.substring(prefix.length() + 1);
            int dotIndex = keyWithoutPrefix.indexOf(46);
            String string = id = dotIndex == -1 ? keyWithoutPrefix : keyWithoutPrefix.substring(0, dotIndex);
            if (id.isEmpty()) {
                String msg = String.format("Malformed group setting name: '%s', does not match any setting in its group.", key);
                if (strict) {
                    throw new IllegalArgumentException(msg + STRICT_FAILURE_MESSAGE);
                }
                this.log.warn(msg);
                continue;
            }
            Map groupInstances = this.allGroupInstances.computeIfAbsent((Class)groupEntry.getValue(), k -> new HashMap());
            if (groupInstances.containsKey(id)) continue;
            try {
                group = (GroupSetting)Config.createStringInstance((Class)groupEntry.getValue(), id);
            }
            catch (IllegalArgumentException e2) {
                String msg = this.createUnrecognizedSettingMessage(key);
                if (strict) {
                    throw new IllegalArgumentException(msg + STRICT_FAILURE_MESSAGE);
                }
                this.log.warn(msg);
                continue;
            }
            groupInstances.put(id, group);
            newSettings.addAll(Config.getDefinedSettings(group.getClass(), group).values());
        }
        return newSettings;
    }

    private String createUnrecognizedSettingMessage(String key) {
        if (key.startsWith(APOC_NAMESPACE)) {
            return String.format("Setting '%s' for APOC was found in the configuration file. In Neo4j v5, APOC settings must be in their own configuration file called apoc.conf.", key);
        }
        return String.format("Unrecognized setting. No declared setting with name: %s.", key);
    }

    private void evaluateSetting(Setting<?> untypedSetting, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Config fromConfig, Map<String, String> overriddenDefaultStrings, Map<String, Object> overriddenDefaultObjects, boolean strict) {
        SettingImpl setting = (SettingImpl)untypedSetting;
        String key = setting.name();
        ValueSource source = ValueSource.DEFAULT;
        try {
            Object defaultValue;
            this.validateSettingName(setting, strict);
            if (overriddenDefaultObjects.containsKey(key)) {
                defaultValue = overriddenDefaultObjects.get(key);
            } else if (overriddenDefaultStrings.containsKey(key)) {
                defaultValue = setting.parse(this.evaluateIfCommand(key, overriddenDefaultStrings.get(key)));
            } else {
                Object fromDefault;
                defaultValue = setting.defaultValue();
                if (fromConfig != null && fromConfig.settings.containsKey(key) && !Objects.equals(defaultValue, fromDefault = fromConfig.settings.get((Object)key).defaultValue)) {
                    defaultValue = fromDefault;
                }
            }
            Object value = null;
            if (settingValueObjects.containsKey(key)) {
                value = settingValueObjects.get(key);
                source = ValueSource.INITIAL;
            } else if (settingValueStrings.containsKey(key)) {
                source = ValueSource.INITIAL;
                value = setting.parse(this.evaluateIfCommand(key, settingValueStrings.get(key)));
            } else if (fromConfig != null && fromConfig.settings.containsKey(key)) {
                Entry<?> entry = fromConfig.settings.get(key);
                value = entry.isDefault ? null : entry.value;
                source = entry.valueSource();
            }
            value = setting.solveDefault(value, defaultValue);
            this.settings.put(key, this.createEntry(setting, value, defaultValue, source));
        }
        catch (AccessDuringEvaluationException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            String msg = String.format("Error evaluating value for setting '%s'. %s", setting.name(), exception.getMessage());
            throw new IllegalArgumentException(msg, exception);
        }
    }

    private void validateSettingName(SettingImpl<Object> setting, boolean strict) {
        this.validateInternalNamespace(setting);
        if (strict) {
            this.validateSettingNamespace(setting);
        }
    }

    public boolean expandCommands() {
        return this.expandCommands;
    }

    private void validateSettingNamespace(SettingImpl<Object> setting) {
        String name = setting.name();
        for (String supportedNamespace : SUPPORTED_NAMESPACES) {
            if (!name.startsWith(supportedNamespace)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Setting: '%s' name does not reside in any of the supported setting namespaces which are: %s", setting.name(), String.join((CharSequence)", ", SUPPORTED_NAMESPACES)));
    }

    private void validateInternalNamespace(SettingImpl<Object> setting) {
        if (setting.internal()) {
            if (!setting.name().startsWith("internal.")) {
                throw new IllegalArgumentException(String.format("Setting: '%s' is internal but does not reside in the correct internal settings namespace.", setting.name()));
            }
        } else if (setting.name().contains("internal") || setting.name().contains("unsupported")) {
            throw new IllegalArgumentException(String.format("Setting: '%s' is not internal but using internal settings namespace.", setting.name()));
        }
    }

    private String evaluateIfCommand(String settingName, String entry) {
        if (Config.isCommand(entry)) {
            Preconditions.checkArgument((boolean)this.expandCommands, (String)String.format("%s is a command, but config is not explicitly told to expand it. (Missing --expand-commands argument?)", entry));
            String str = entry.trim();
            String command = str.substring(2, str.length() - 1);
            this.log.info("Executing external script to retrieve value of setting " + settingName);
            return ProcessUtils.executeCommandWithOutput((String)command, (Duration)this.commandEvaluationTimeout);
        }
        return entry;
    }

    public static boolean isCommand(String entry) {
        String str = entry.trim();
        return str.length() > 3 && str.charAt(0) == '$' && str.charAt(1) == '(' && str.charAt(str.length() - 1) == ')';
    }

    private <T> Entry<T> createEntry(SettingImpl<T> setting, T value, T defaultValue, ValueSource source) {
        if (setting.dependency() != null) {
            Entry<?> dep = this.settings.get(setting.dependency().name());
            T solvedValue = setting.solveDependency(value != null ? value : defaultValue, dep.getValue());
            return new DepEntry<T>(setting, value, defaultValue, solvedValue, source);
        }
        return new Entry<T>(setting, value, defaultValue, source);
    }

    public <T extends GroupSetting> Map<String, T> getGroups(Class<T> group) {
        return new HashMap(this.allGroupInstances.getOrDefault(group, new HashMap()));
    }

    public <T extends GroupSetting, U extends T> Map<Class<U>, Map<String, U>> getGroupsFromInheritance(Class<T> parentClass) {
        return this.allGroupInstances.keySet().stream().filter(parentClass::isAssignableFrom).map(childClass -> childClass).collect(Collectors.toMap(childClass -> childClass, this::getGroups));
    }

    private static <T> T createInstance(Class<T> classObj) {
        T instance;
        try {
            instance = Config.createStringInstance(classObj, null);
        }
        catch (Exception first) {
            try {
                Constructor<T> constructor = classObj.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception second) {
                String name = classObj.getSimpleName();
                String msg = String.format("Failed to create instance of: %s, please see the exception cause", name);
                throw new IllegalArgumentException(msg, Exceptions.chain((Throwable)second, (Throwable)first));
            }
        }
        return instance;
    }

    public <T> T get(Setting<T> setting) {
        return this.getObserver(setting).getValue();
    }

    public <T> T getDefault(Setting<T> setting) {
        return ((Entry)this.getObserver(setting)).defaultValue();
    }

    public <T> T getStartupValue(Setting<T> setting) {
        return ((Entry)this.getObserver(setting)).startupValue();
    }

    public <T> ValueSource getValueSource(Setting<T> setting) {
        return ((Entry)this.getObserver(setting)).valueSource();
    }

    public <T> SettingObserver<T> getObserver(Setting<T> setting) {
        SettingObserver observer = this.settings.get(setting.name());
        if (observer != null) {
            return observer;
        }
        throw new IllegalArgumentException(String.format("Config has no association with setting: '%s'", setting.name()));
    }

    public <T> void setDynamic(Setting<T> setting, T value, String scope) {
        this.setDynamic(setting, value, scope, ValueSource.SYSTEM);
    }

    public <T> void setDynamicByUser(Setting<T> setting, T value, String scope) {
        this.setDynamic(setting, value, scope, ValueSource.USER);
    }

    private <T> void setDynamic(Setting<T> setting, T value, String scope, ValueSource source) {
        Entry entry = (Entry)this.getObserver(setting);
        SettingImpl<T> actualSetting = entry.setting;
        if (!actualSetting.dynamic()) {
            throw new IllegalArgumentException(String.format("Setting '%s' is not dynamic and can not be changed at runtime", setting.name()));
        }
        this.set(setting, value, source);
        this.log.info("%s changed to %s, by %s", new Object[]{setting.name(), actualSetting.valueToString(value), scope});
    }

    public <T> void set(Setting<T> setting, T value) {
        this.set(setting, value, ValueSource.SYSTEM);
    }

    private <T> void set(Setting<T> setting, T value, ValueSource source) {
        Entry entry = (Entry)this.getObserver(setting);
        SettingImpl actualSetting = entry.setting;
        if (actualSetting.immutable()) {
            throw new IllegalArgumentException(String.format("Setting '%s' immutable (final). Can not amend", actualSetting.name()));
        }
        entry.setValue(value, source);
    }

    public <T> void setIfNotSet(Setting<T> setting, T value) {
        Entry entry = (Entry)this.getObserver(setting);
        if (entry == null || entry.isDefault) {
            this.set(setting, value);
        }
    }

    public boolean isExplicitlySet(Setting<?> setting) {
        if (this.settings.containsKey(setting.name())) {
            return !this.settings.get((Object)setting.name()).isDefault;
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeNullValues) {
        StringBuilder sb = new StringBuilder();
        this.settings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            SettingImpl setting = ((Entry)e.getValue()).setting;
            Object valueObj = ((Entry)e.getValue()).getValue();
            if (valueObj != null || includeNullValues) {
                String value = setting.valueToString(valueObj);
                sb.append(String.format("%s=%s%n", e.getKey(), value));
            }
        });
        return sb.toString();
    }

    public void setLogger(InternalLog log) {
        if (this.log instanceof BufferingLog) {
            ((BufferingLog)this.log).replayInto(log);
        }
        this.log = log;
    }

    public Setting<Object> getSetting(String name) {
        if (!this.settings.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Setting `%s` not found", name));
        }
        return this.settings.get((Object)name).setting;
    }

    public Map<String, Setting<Object>> getDeclaredSettings() {
        return this.settings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Entry)entry.getValue()).setting));
    }

    public Object configStringLookup(String setting) {
        return this.get(this.getSetting(setting));
    }

    private static Map<String, Class<? extends GroupSetting>> getDefinedGroups(Collection<Class<? extends GroupSetting>> groupSettingClasses) {
        return groupSettingClasses.stream().collect(Collectors.toMap(cls -> ((GroupSetting)Config.createInstance(cls)).getPrefix(), cls -> cls));
    }

    private static <T> T createStringInstance(Class<T> cls, String id) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return constructor.newInstance(id);
        }
        catch (Exception e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("Could not create instance with id: " + id, e);
            }
            String msg = String.format("'%s' must have a ( String ) constructor, be static & non-abstract", cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
    }

    private static Map<String, SettingImpl<?>> getDefinedSettings(Collection<Class<? extends SettingsDeclaration>> settingsClasses) {
        HashMap settings = new HashMap();
        settingsClasses.forEach(c -> settings.putAll(Config.getDefinedSettings(c, null)));
        return settings;
    }

    private static Map<String, SettingImpl<?>> getDefinedSettings(Class<?> settingClass, Object fromObject) {
        HashMap settings = new HashMap();
        Arrays.stream(FieldUtils.getAllFields(settingClass)).filter(f -> f.getType().isAssignableFrom(SettingImpl.class)).forEach(field -> {
            try {
                field.setAccessible(true);
                SettingImpl setting = (SettingImpl)field.get(fromObject);
                if (field.isAnnotationPresent(Description.class)) {
                    setting.setDescription(field.getAnnotation(Description.class).value());
                }
                if (field.isAnnotationPresent(Internal.class)) {
                    setting.setInternal();
                }
                if (field.isAnnotationPresent(Deprecated.class)) {
                    setting.setDeprecated();
                }
                Class<?> owningClass = field.getDeclaringClass();
                String name = Objects.requireNonNullElse(owningClass.getCanonicalName(), owningClass.getName());
                setting.setSourceLocation(name + "." + field.getName());
                settings.put(setting.name(), setting);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("%s %s, from %s is not accessible.", field.getType(), field.getName(), settingClass.getSimpleName()), e);
            }
        });
        return settings;
    }

    public <T> void addListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Entry entry = (Entry)this.getObserver(setting);
        entry.addListener(listener);
    }

    public <T> void removeListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Entry entry = (Entry)this.getObserver(setting);
        entry.removeListener(listener);
    }

    public static final class Builder {
        public static final String ENV_CONFIG_FILE_CHARSET = "NEO4J_CONFIG_FILE_CHARSET";
        private final Collection<Class<? extends SettingsDeclaration>> settingsClasses = new TreeSet<Class>(Comparator.comparing(Class::getName));
        private final Collection<Class<? extends GroupSetting>> groupSettingClasses = new TreeSet<Class>(Comparator.comparing(Class::getName));
        private final Collection<SettingMigrator> settingMigrators = new TreeSet<SettingMigrator>(Comparator.comparing(o -> o.getClass().getName()));
        private final Map<String, String> settingValueStrings = new HashMap<String, String>();
        private final Map<String, Object> settingValueObjects = new HashMap<String, Object>();
        private final Map<String, Object> overriddenDefaults = new HashMap<String, Object>();
        private final List<Path> configFiles = new ArrayList<Path>();
        private Config fromConfig;
        private final InternalLog log = new BufferingLog();
        private boolean expandCommands;
        private Charset fileCharset = StandardCharsets.ISO_8859_1;
        private String strictDuplicateDeclarationWarningMessage;

        private static <T> boolean allowedToOverrideValues(String setting, T value, Map<String, T> settingValues) {
            if (Builder.allowedMultipleDeclarations(setting)) {
                T oldValue = settingValues.get(setting);
                if (oldValue != null) {
                    if (value instanceof String && oldValue instanceof String) {
                        String newValue = String.valueOf(oldValue) + System.lineSeparator() + String.valueOf(value);
                        settingValues.put(setting, newValue);
                    } else {
                        throw new IllegalArgumentException(setting + " can only be provided as raw Strings if provided multiple times");
                    }
                }
                return false;
            }
            return true;
        }

        public static boolean allowedMultipleDeclarations(String setting) {
            return Objects.equals(setting, BootloaderSettings.additional_jvm.name()) || Objects.equals(setting, Config.LEGACY_4_X_DBMS_JVM_ADDITIONAL);
        }

        private <T> void overrideSettingValue(String setting, T value, Map<String, T> settingValues, boolean force) {
            if (!this.settingValueStrings.containsKey(setting) && !this.settingValueObjects.containsKey(setting)) {
                settingValues.put(setting, value);
            } else if (force || Builder.allowedToOverrideValues(setting, value, settingValues)) {
                this.log.warn("The '%s' setting is overridden. Setting value changed from '%s' to '%s'.", new Object[]{setting, this.settingValueStrings.containsKey(setting) ? this.settingValueStrings.remove(setting) : this.settingValueObjects.remove(setting), value});
                settingValues.put(setting, value);
            }
        }

        private Builder setRaw(String setting, String value) {
            this.setRaw(setting, value, false);
            return this;
        }

        private Builder setRaw(String setting, String value, boolean forceOverride) {
            this.overrideSettingValue(setting, value, this.settingValueStrings, forceOverride);
            return this;
        }

        private Builder set(String setting, Object value) {
            this.overrideSettingValue(setting, value, this.settingValueObjects, false);
            return this;
        }

        public Builder setRaw(Map<String, String> settingValues) {
            settingValues.forEach(this::setRaw);
            return this;
        }

        public <T> Builder set(Setting<T> setting, T value) {
            return this.set(setting.name(), value);
        }

        public Builder set(Map<Setting<?>, Object> settingValues) {
            settingValues.forEach((setting, value) -> this.set(setting.name(), value));
            return this;
        }

        private Builder setDefault(String setting, Object value) {
            if (!this.overriddenDefaults.containsKey(setting)) {
                this.overriddenDefaults.put(setting, value);
            } else if (Builder.allowedToOverrideValues(setting, value, this.overriddenDefaults)) {
                this.log.warn("The overridden default value of '%s' setting is overridden. Setting value changed from '%s' to '%s'.", new Object[]{setting, this.overriddenDefaults.get(setting), value});
                this.overriddenDefaults.put(setting, value);
            }
            return this;
        }

        public Builder setDefaults(Map<Setting<?>, Object> overriddenDefaults) {
            overriddenDefaults.forEach((setting, value) -> this.setDefault(setting.name(), value));
            return this;
        }

        public <T> Builder setDefault(Setting<T> setting, T value) {
            return this.setDefault(setting.name(), value);
        }

        public Builder remove(Setting<?> setting) {
            this.settingValueStrings.remove(setting.name());
            this.settingValueObjects.remove(setting.name());
            return this;
        }

        public Builder removeDefault(Setting<?> setting) {
            this.overriddenDefaults.remove(setting.name());
            return this;
        }

        Builder addSettingsClass(Class<? extends SettingsDeclaration> settingsClass) {
            this.settingsClasses.add(settingsClass);
            return this;
        }

        Builder addGroupSettingClass(Class<? extends GroupSetting> groupSettingClass) {
            this.groupSettingClasses.add(groupSettingClass);
            return this;
        }

        public Builder addMigrator(SettingMigrator migrator) {
            this.settingMigrators.add(migrator);
            return this;
        }

        public Builder setFileCharset(Charset charset) {
            this.fileCharset = charset;
            return this;
        }

        public Builder fromConfig(Config config) {
            if (this.fromConfig != null) {
                throw new IllegalArgumentException("Can only build a config from one other config.");
            }
            while (config instanceof DatabaseConfig) {
                config = ((DatabaseConfig)config).getGlobalConfig();
            }
            this.fromConfig = config;
            return this;
        }

        public Builder fromFileNoThrow(Path path) {
            if (path != null) {
                this.fromFile(path, false, s -> true);
            }
            return this;
        }

        public Builder fromFile(Path cfg) {
            return this.fromFile(cfg, true, s -> true);
        }

        public Builder fromFile(Path file, boolean allowThrow, final Predicate<String> filter) {
            block11: {
                if (file == null || Files.notExists(file, new LinkOption[0])) {
                    if (allowThrow) {
                        throw new IllegalArgumentException(new IOException("Config file [" + String.valueOf(file) + "] does not exist."));
                    }
                    this.log.warn("Config file [%s] does not exist.", new Object[]{file});
                    return this;
                }
                try {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        Files.walkFileTree(file, new ConfigDirectoryFileVisitor(file));
                        break block11;
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), this.fileCharset));){
                        new Properties(){
                            private final Set<String> duplicateDetection = new HashSet<String>();

                            @Override
                            public synchronized Object put(Object key, Object value) {
                                String setting = key.toString();
                                if (filter.test(setting)) {
                                    boolean forceDuplicateOverride = false;
                                    if (!this.duplicateDetection.add(setting)) {
                                        if (!Builder.allowedMultipleDeclarations(setting)) {
                                            strictDuplicateDeclarationWarningMessage = setting + " declared multiple times.";
                                        }
                                    } else if (Builder.allowedMultipleDeclarations(setting)) {
                                        forceDuplicateOverride = true;
                                    }
                                    this.setRaw(setting, value.toString(), forceDuplicateOverride);
                                }
                                return null;
                            }
                        }.load(reader);
                    }
                    this.configFiles.add(file);
                }
                catch (IOException e) {
                    if (allowThrow) {
                        throw new IllegalArgumentException("Unable to load config file [" + String.valueOf(file) + "].", e);
                    }
                    this.log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
                }
            }
            return this;
        }

        public Builder allowCommandExpansion() {
            return this.commandExpansion(true);
        }

        public Builder commandExpansion(boolean expandCommands) {
            this.expandCommands = expandCommands;
            return this;
        }

        private Builder() {
            String charsetOverride = System.getenv(ENV_CONFIG_FILE_CHARSET);
            if (charsetOverride != null) {
                try {
                    this.fileCharset = Charset.forName(charsetOverride);
                }
                catch (Exception e) {
                    this.log.warn("Could not use requested configuration file charset '" + charsetOverride + "'", (Throwable)e);
                }
            }
        }

        public Config build() {
            this.expandCommands |= this.fromConfig != null && this.fromConfig.expandCommands;
            if (this.expandCommands) {
                Builder.validateFilePermissionForCommandExpansion(this.configFiles);
            }
            return new Config(this.settingsClasses, this.groupSettingClasses, this.settingMigrators, this.settingValueStrings, this.settingValueObjects, this.overriddenDefaults, this.fromConfig, this.log, this.expandCommands, this.strictDuplicateDeclarationWarningMessage);
        }

        public static void validateFilePermissionForCommandExpansion(List<Path> files) {
            if (files.isEmpty()) {
                return;
            }
            if (SystemUtils.IS_OS_UNIX) {
                for (Path path : files) {
                    try {
                        PosixFileAttributes attrs;
                        Set<PosixFilePermission> permissions;
                        Set<PosixFilePermission> unixPermission640 = Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ);
                        if (unixPermission640.containsAll(permissions = (attrs = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes()).permissions())) continue;
                        throw new IllegalArgumentException(String.format("%s does not have the correct file permissions to evaluate commands. Has %s, requires at most %s.", path, permissions, unixPermission640));
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        throw new IllegalStateException("Unable to access file permissions for " + String.valueOf(path), e);
                    }
                }
            } else if (SystemUtils.IS_OS_WINDOWS) {
                String processOwner = SystemProperties.getUserName();
                for (Path path : files) {
                    try {
                        AclFileAttributeView attrs = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
                        UserPrincipal owner = attrs.getOwner();
                        Set<AclEntryPermission> windowsUserNoExecute = Set.of(AclEntryPermission.READ_DATA, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_ACL, AclEntryPermission.DELETE, AclEntryPermission.DELETE_CHILD, AclEntryPermission.WRITE_OWNER, AclEntryPermission.SYNCHRONIZE);
                        for (AclEntry acl : attrs.getAcl()) {
                            Set<AclEntryPermission> permissions = acl.permissions();
                            if (!AclEntryType.ALLOW.equals((Object)acl.type())) continue;
                            if (acl.principal().equals(owner)) {
                                if (windowsUserNoExecute.containsAll(permissions)) continue;
                                throw new IllegalArgumentException(String.format("%s does not have the correct ACL for owner to evaluate commands. Has %s for %s, requires at most %s.", path, permissions, acl.principal().getName(), windowsUserNoExecute));
                            }
                            if (permissions.isEmpty()) continue;
                            throw new IllegalArgumentException(String.format("%s does not have the correct ACL. Has %s for %s, should be none for all except owner.", path, permissions, acl.principal().getName()));
                        }
                        String domainAndName = owner.getName();
                        String fileOwner = domainAndName.contains("\\") ? domainAndName.split("\\\\")[1] : domainAndName;
                        if (fileOwner.equals(processOwner)) continue;
                        throw new IllegalArgumentException(String.format("%s does not have the correct file owner to evaluate commands. Has %s, requires %s.", path, domainAndName, processOwner));
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        throw new IllegalStateException("Unable to access file permissions for " + String.valueOf(path), e);
                    }
                }
            } else {
                throw new IllegalStateException("Configuration command expansion not supported for " + SystemUtils.OS_NAME);
            }
        }

        private class ConfigDirectoryFileVisitor
        implements FileVisitor<Path> {
            private final Path root;

            ConfigDirectoryFileVisitor(Path root) {
                this.root = root;
            }

            private boolean isRoot(Path dir) {
                return this.root.equals(dir);
            }

            private boolean isNotHidden(Path file) {
                return !file.getFileName().toString().startsWith(".");
            }

            private boolean isFile(Path file, BasicFileAttributes attrs) {
                return attrs.isRegularFile() || Files.isRegularFile(file, new LinkOption[0]);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (this.isRoot(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                if (this.isNotHidden(dir)) {
                    Builder.this.log.warn("Ignoring subdirectory in config directory [" + String.valueOf(dir) + "].");
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (this.isNotHidden(file) && this.isFile(file, attrs)) {
                    String key = file.getFileName().toString();
                    String value = Files.readString(file);
                    Builder.this.setRaw(key, value);
                    Builder.this.configFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc != null ? exc : new IOException("Unknown failure loading config file [" + String.valueOf(file.toAbsolutePath()) + "]");
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                return FileVisitResult.CONTINUE;
            }
        }
    }

    private class ValidationConfig
    implements Configuration {
        private ValidationConfig() {
        }

        public <T> T get(Setting<T> setting) {
            if (setting.dynamic()) {
                throw new IllegalArgumentException("Can not depend on dynamic setting:" + setting.name());
            }
            if (!Config.this.settings.containsKey(setting.name())) {
                throw new AccessDuringEvaluationException(setting);
            }
            return Config.this.get(setting);
        }
    }

    private class Entry<T>
    implements SettingObserver<T> {
        protected final SettingImpl<T> setting;
        protected final T defaultValue;
        private final boolean validate;
        private final Collection<SettingChangeListener<T>> updateListeners = new ConcurrentLinkedQueue<SettingChangeListener<T>>();
        private volatile T value;
        private volatile boolean isDefault;
        private volatile ValueSource valueSource;
        private final T startupValue;

        private Entry(SettingImpl<T> setting, T value, T defaultValue, ValueSource source) {
            this(setting, value, defaultValue, source, true);
        }

        private Entry(SettingImpl<T> setting, T value, T defaultValue, ValueSource source, boolean validate) {
            this.setting = setting;
            this.defaultValue = defaultValue;
            this.validate = validate;
            this.internalSetValue(value, source);
            this.startupValue = this.value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        T defaultValue() {
            return this.defaultValue;
        }

        T startupValue() {
            return this.startupValue;
        }

        ValueSource valueSource() {
            return this.valueSource;
        }

        synchronized void setValue(T value, ValueSource source) {
            T oldValue = this.value;
            this.internalSetValue(value, source);
            this.notifyListeners(oldValue, this.value);
        }

        void internalSetValue(T value, ValueSource source) {
            this.isDefault = value == null;
            T newValue = this.isDefault ? this.defaultValue : value;
            ValueSource valueSource = this.valueSource = this.isDefault ? ValueSource.DEFAULT : source;
            if (this.validate) {
                this.setting.validate(newValue, Config.this.validationConfig);
            }
            this.value = newValue;
        }

        protected void notifyListeners(T oldValue, T newValue) {
            this.updateListeners.forEach(listener -> listener.accept(oldValue, newValue));
        }

        private void addListener(SettingChangeListener<T> listener) {
            if (!this.setting.dynamic()) {
                throw new IllegalArgumentException("Setting is not dynamic and will not change");
            }
            this.updateListeners.add(listener);
        }

        private void removeListener(SettingChangeListener<T> listener) {
            this.updateListeners.remove(listener);
        }

        public String toString() {
            return this.setting.valueToString(this.value) + (this.isDefault ? " (default)" : " (configured)");
        }
    }

    private static class AccessDuringEvaluationException
    extends RuntimeException {
        private final Setting<?> attemptedAccess;

        AccessDuringEvaluationException(Setting<?> attemptedAccess) {
            super(String.format("AccessDuringEvaluationException{ Tried to access %s in config during construction }", attemptedAccess.name()));
            this.attemptedAccess = attemptedAccess;
        }

        Setting<?> getAttemptedAccess() {
            return this.attemptedAccess;
        }
    }

    public static enum ValueSource {
        DEFAULT,
        INITIAL,
        SYSTEM,
        USER;

    }

    private class DepEntry<T>
    extends Entry<T> {
        private volatile T solved;

        private DepEntry(SettingImpl<T> setting, T value, T defaultValue, T solved, ValueSource source) {
            super(setting, value, defaultValue, source, false);
            this.solved = solved;
            setting.validate(solved, Config.this.validationConfig);
        }

        @Override
        public T getValue() {
            return this.solved;
        }

        @Override
        synchronized void setValue(T value, ValueSource source) {
            T oldValue = this.solved;
            this.solved = this.setting.solveDependency(value != null ? value : this.defaultValue, Config.this.getObserver(this.setting.dependency()).getValue());
            this.setting.validate(this.solved, Config.this.validationConfig);
            this.internalSetValue(value, source);
            this.notifyListeners(oldValue, this.solved);
        }
    }
}

