/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.PrintWriter;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractPrintWriterLogger;
import org.neo4j.logging.Logger;

public class ConsistencyReportLogger
extends AbstractPrintWriterLogger {
    private final String prefix;

    public ConsistencyReportLogger(@Nonnull Supplier<PrintWriter> writerSupplier, @Nonnull Object lock, String prefix, boolean autoFlush) {
        super(writerSupplier, lock, autoFlush);
        this.prefix = prefix;
    }

    protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message) {
        out.write(this.prefix);
        out.write(": ");
        out.write(message);
        out.println();
    }

    protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message, @Nonnull Throwable throwable) {
        out.write(this.prefix);
        out.write(": ");
        out.write(message);
        out.write(32);
        out.write(throwable.getMessage());
        out.println();
        throwable.printStackTrace(out);
    }

    protected Logger getBulkLogger(@Nonnull PrintWriter out, @Nonnull Object lock) {
        return new ConsistencyReportLogger(Suppliers.singleton((Object)out), lock, this.prefix, false);
    }
}

