/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import java.util.function.Function;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.helpers.Numbers;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class MandatoryProperties {
    private final MutableIntObjectMap<int[]> nodes = new IntObjectHashMap();
    private final MutableIntObjectMap<int[]> relationships = new IntObjectHashMap();
    private final StoreAccess storeAccess;
    private SchemaProcessor constraintRecorder = new SchemaProcessor(){

        public void processSpecific(LabelSchemaDescriptor schema) {
            for (int propertyId : schema.getPropertyIds()) {
                MandatoryProperties.recordConstraint(schema.getLabelId(), propertyId, (MutableIntObjectMap<int[]>)MandatoryProperties.this.nodes);
            }
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            for (int propertyId : schema.getPropertyIds()) {
                MandatoryProperties.recordConstraint(schema.getRelTypeId(), propertyId, (MutableIntObjectMap<int[]>)MandatoryProperties.this.relationships);
            }
        }

        public void processSpecific(SchemaDescriptor schema) {
            throw new IllegalStateException("General SchemaDescriptors cannot support constraints");
        }
    };
    private static final Check NONE = new Check(){

        @Override
        public void receive(int[] keys) {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "NONE";
        }
    };

    public MandatoryProperties(StoreAccess storeAccess) {
        this.storeAccess = storeAccess;
        SchemaStorage schemaStorage = new SchemaStorage(storeAccess.getSchemaStore());
        for (ConstraintRule rule : this.constraintsIgnoringMalformed(schemaStorage)) {
            if (!rule.getConstraintDescriptor().enforcesPropertyExistence()) continue;
            rule.schema().processWith(this.constraintRecorder);
        }
    }

    public Function<NodeRecord, Check<NodeRecord, ConsistencyReport.NodeConsistencyReport>> forNodes(ConsistencyReporter reporter) {
        return node -> {
            IntHashSet keys = null;
            for (long labelId : NodeLabelReader.getListOfLabels(node, (RecordStore<DynamicRecord>)this.storeAccess.getNodeDynamicLabelStore())) {
                int[] propertyKeys = (int[])this.nodes.get(Numbers.safeCastLongToInt((long)labelId));
                if (propertyKeys == null) continue;
                if (keys == null) {
                    keys = new IntHashSet(16);
                }
                for (int key : propertyKeys) {
                    keys.add(key);
                }
            }
            return keys != null ? new RealCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport>((NodeRecord)node, ConsistencyReport.NodeConsistencyReport.class, reporter, RecordType.NODE, (MutableIntSet)keys) : MandatoryProperties.noCheck();
        };
    }

    public Function<RelationshipRecord, Check<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>> forRelationships(ConsistencyReporter reporter) {
        return relationship -> {
            int[] propertyKeys = (int[])this.relationships.get(relationship.getType());
            if (propertyKeys != null) {
                IntHashSet keys = new IntHashSet(propertyKeys.length);
                for (int key : propertyKeys) {
                    keys.add(key);
                }
                return new RealCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>((RelationshipRecord)relationship, ConsistencyReport.RelationshipConsistencyReport.class, reporter, RecordType.RELATIONSHIP, (MutableIntSet)keys);
            }
            return MandatoryProperties.noCheck();
        };
    }

    private Iterable<ConstraintRule> constraintsIgnoringMalformed(SchemaStorage schemaStorage) {
        return () -> ((SchemaStorage)schemaStorage).constraintsGetAllIgnoreMalformed();
    }

    private static void recordConstraint(int labelOrRelType, int propertyKey, MutableIntObjectMap<int[]> storage) {
        int[] propertyKeys = (int[])storage.get(labelOrRelType);
        if (propertyKeys == null) {
            propertyKeys = new int[]{propertyKey};
        } else {
            propertyKeys = Arrays.copyOf(propertyKeys, propertyKeys.length + 1);
            propertyKeys[propertyKeys.length - 1] = propertyKey;
        }
        storage.put(labelOrRelType, (Object)propertyKeys);
    }

    private static <RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport> Check<RECORD, REPORT> noCheck() {
        return NONE;
    }

    private static class RealCheck<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
    implements Check<RECORD, REPORT> {
        private final RECORD record;
        private final MutableIntSet mandatoryKeys;
        private final Class<REPORT> reportClass;
        private final ConsistencyReporter reporter;
        private final RecordType recordType;

        RealCheck(RECORD record, Class<REPORT> reportClass, ConsistencyReporter reporter, RecordType recordType, MutableIntSet mandatoryKeys) {
            this.record = record;
            this.reportClass = reportClass;
            this.reporter = reporter;
            this.recordType = recordType;
            this.mandatoryKeys = mandatoryKeys;
        }

        @Override
        public void receive(int[] keys) {
            for (int key : keys) {
                this.mandatoryKeys.remove(key);
            }
        }

        @Override
        public void close() {
            if (!this.mandatoryKeys.isEmpty()) {
                MutableIntIterator key = this.mandatoryKeys.intIterator();
                while (key.hasNext()) {
                    ((ConsistencyReport.PrimitiveConsistencyReport)this.reporter.report(this.record, this.reportClass, this.recordType)).missingMandatoryProperty(key.next());
                }
            }
        }

        public String toString() {
            return "Mandatory properties: " + this.mandatoryKeys;
        }
    }

    public static interface Check<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
    extends AutoCloseable {
        public void receive(int[] var1);

        @Override
        public void close();
    }
}

